/*
 * Decompiled with CFR 0.152.
 */
package com.meta.tws2.service.impl;

import com.meta.tws2.Documents.HistoryConversationItem;
import com.meta.tws2.Repository.Services.ConversationDAO;
import com.meta.tws2.client.tsa.TsaApiService;
import com.meta.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.meta.tws2.data.ExtractData;
import com.meta.tws2.data.FileMessageRequestFromHiper;
import com.meta.tws2.data.TextMessageRequest;
import com.meta.tws2.data.tsa.RequestMessageModel;
import com.meta.tws2.service.HistoryConversationItemService;
import com.meta.tws2.service.StateConversationService;
import com.meta.tws2.service.ThinkAgentService;
import com.meta.tws2.utils.MessageTypeUtils;
import com.meta.tws2.utils.StatusUtil;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final TsaApiService tsaApiService;
    private final StateConversationService stateConversationService;
    private final ApiWhatsAppService whatsAppService;
    private final HistoryConversationItemService historyConversationItemService;
    private final ConversationDAO conversationDAO;
    private final Environment env;

    public Mono<ResponseEntity<String>> sendMessageToWhatsappFromTSA(RequestMessageModel requestMessageModel) {
        HistoryConversationItem historyConversationItem = new HistoryConversationItem(requestMessageModel.getId(), requestMessageModel.getChannel(), requestMessageModel.getPayload().getContent(), StatusUtil.ST_ASESOR, StatusUtil.ST_THINKAGENT, requestMessageModel.getNick());
        return this.processMessageToTsa(requestMessageModel).flatMap(response -> {
            log.info("response webhook {}", response);
            historyConversationItem.setMessageMetaId((String)response.getBody());
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")).then(this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), StatusUtil.ST_THINKAGENT)).then(this.historyConversationItemService.save(historyConversationItem)).thenReturn(response);
        });
    }

    private Mono<ResponseEntity<String>> processMessageToTsa(RequestMessageModel requestMessageModel) {
        switch (requestMessageModel.getPayload().getType()) {
            case "text": {
                TextMessageRequest textMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
                if (textMessage.getMessage().toUpperCase().contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                    return this.whatsAppService.sendTextMessage(textMessage).flatMap(messageMetaId -> {
                        log.info("Meta message id: {}", messageMetaId);
                        return this.stateConversationService.updateStateByConversationId(textMessage.getPhoneNumber(), StatusUtil.ST_NORMAL).map(response -> messageMetaId);
                    });
                }
                if (textMessage.getMessage().toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                    log.info("Mensaje de eliminaci\u00f3n ignorado");
                    return Mono.just((Object)ResponseEntity.ok((Object)UUID.randomUUID().toString()));
                }
                return this.whatsAppService.sendTextMessage(textMessage);
            }
            case "image": {
                FileMessageRequestFromHiper imageFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendImageMessage(imageFileRequest);
            }
            case "video": {
                FileMessageRequestFromHiper videoFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendVideoMessage(videoFileRequest);
            }
            case "document": {
                FileMessageRequestFromHiper documentFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendDocumentMessage(documentFileRequest);
            }
            case "audio": {
                FileMessageRequestFromHiper audioFileRequest = new FileMessageRequestFromHiper(requestMessageModel.getId(), requestMessageModel.getPayload().getContent(), "");
                return this.whatsAppService.sendAudioMessage(audioFileRequest);
            }
        }
        TextMessageRequest unknowTextMessage = new TextMessageRequest(requestMessageModel.getId(), requestMessageModel.getPayload().getContent());
        return this.whatsAppService.sendTextMessage(unknowTextMessage);
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(ExtractData dataMessageMeta) {
        log.info("Data message meta: {}", (Object)dataMessageMeta);
        String defaultCallback = this.env.getProperty("canal.callback.default");
        RequestMessageModel requestMessageModel = new RequestMessageModel();
        RequestMessageModel.Payload payload = new RequestMessageModel.Payload();
        if (dataMessageMeta.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
            payload.setType(dataMessageMeta.getType());
            payload.setContent(dataMessageMeta.getMessage());
        } else {
            payload.setType(MessageTypeUtils.TYPE_FILE);
            payload.setContent(dataMessageMeta.getFile());
        }
        requestMessageModel.setType("message");
        requestMessageModel.setId(dataMessageMeta.getIdConversation());
        requestMessageModel.setPayload(payload);
        requestMessageModel.setChannel("whatsapp");
        requestMessageModel.setNick(dataMessageMeta.getNick());
        if (dataMessageMeta.getReplyMessageId() != null) {
            return this.historyConversationItemService.getMessageByMetaId(dataMessageMeta.getReplyMessageId()).flatMap(message -> {
                log.info("The message replied is: {}", message);
                requestMessageModel.getPayload().setRepliedMessage(message);
                return this.conversationDAO.getCallbackByConversationId(dataMessageMeta.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId));
            });
        }
        return this.conversationDAO.getCallbackByConversationId(dataMessageMeta.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId));
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(RequestMessageModel requestMessageModel, String callbackId) {
        return this.tsaApiService.sendMesssageToAsesor(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"));
        });
    }

    public ThinkAgentServiceImpl(TsaApiService tsaApiService, StateConversationService stateConversationService, ApiWhatsAppService whatsAppService, HistoryConversationItemService historyConversationItemService, ConversationDAO conversationDAO, Environment env) {
        this.tsaApiService = tsaApiService;
        this.stateConversationService = stateConversationService;
        this.whatsAppService = whatsAppService;
        this.historyConversationItemService = historyConversationItemService;
        this.conversationDAO = conversationDAO;
        this.env = env;
    }
}

