/*
 * Decompiled with CFR 0.152.
 */
package com.meta.tws2.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.meta.tws2.Documents.CampaignModel;
import com.meta.tws2.Documents.HistoryConversationItem;
import com.meta.tws2.Documents.ImagenModel;
import com.meta.tws2.Repository.ImagenMessageRepository;
import com.meta.tws2.Repository.Services.CampaignMessageDAO;
import com.meta.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.meta.tws2.data.ConversationSummaryResponse;
import com.meta.tws2.data.campaigns.whatsapp.ComponentWhatsapp;
import com.meta.tws2.data.campaigns.whatsapp.TemplateWhatsApp;
import com.meta.tws2.data.campaigns.whatsapp.WhatsAppCampaignModel;
import com.meta.tws2.data.templatesMeta.TemplateData;
import com.meta.tws2.data.templatesMeta.WhatsAppTemplate;
import com.meta.tws2.data.templatesMeta.WhatsAppTemplateRequest;
import com.meta.tws2.exceptions.TemplateNotFoundException;
import com.meta.tws2.service.HistoryConversationItemService;
import com.meta.tws2.service.StateConversationService;
import com.meta.tws2.service.TemplateService;
import com.meta.tws2.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private final ApiWhatsAppService whatsAppService;
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationService;
    private final ObjectMapper objectMapper;
    private final Environment env;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ImagenMessageRepository imagenRepository;
    private static final Map<String, String> CHANNEL_TITLES = new HashMap();

    public Mono<List<WhatsAppTemplate>> getTemplates() {
        log.info("FILTER ALL TEMPLATES");
        return this.whatsAppService.getTemplates().flatMap(json -> {
            try {
                ArrayList<WhatsAppTemplate> templates = new ArrayList<WhatsAppTemplate>();
                JsonNode rootNode = this.objectMapper.readTree(json);
                JsonNode dataNode = rootNode.path("data");
                if (dataNode.isArray()) {
                    for (JsonNode templateNode : dataNode) {
                        WhatsAppTemplate template = new WhatsAppTemplate();
                        template.setName(templateNode.path("name").asText());
                        template.setLanguage(templateNode.path("language").asText());
                        template.setStatus(templateNode.path("status").asText());
                        template.setCategory(templateNode.path("category").asText());
                        template.setId(templateNode.path("id").asText());
                        ArrayList<WhatsAppTemplate.Component> components = new ArrayList<WhatsAppTemplate.Component>();
                        for (JsonNode componentNode : templateNode.path("components")) {
                            WhatsAppTemplate.Component component = new WhatsAppTemplate.Component();
                            component.setType(componentNode.path("type").asText());
                            component.setText(componentNode.path("text").asText());
                            components.add(component);
                        }
                        template.setComponents(components);
                        templates.add(template);
                    }
                }
                return Mono.just(templates);
            }
            catch (JsonProcessingException e) {
                log.error("Error parsing templates", (Throwable)e);
                return Mono.error((Throwable)new RuntimeException("Error parsing templates"));
            }
        });
    }

    public Mono<List<WhatsAppTemplate>> getTemplatesV2() {
        log.info("FILTER ALL TEMPLATES");
        return this.whatsAppService.getTemplatesV2().flatMap(data -> {
            try {
                ArrayList<WhatsAppTemplate> templates = new ArrayList<WhatsAppTemplate>();
                if (data == null || data.getData() == null) {
                    return Mono.just(templates);
                }
                for (TemplateData.Template templateNode : data.getData()) {
                    WhatsAppTemplate template = new WhatsAppTemplate();
                    template.setName(templateNode.getName());
                    template.setLanguage(templateNode.getLanguage());
                    template.setStatus(templateNode.getStatus());
                    template.setCategory(templateNode.getCategory());
                    template.setId(templateNode.getId());
                    ArrayList<WhatsAppTemplate.Component> components = new ArrayList<WhatsAppTemplate.Component>();
                    for (TemplateData.Component componentNode : templateNode.getComponents()) {
                        WhatsAppTemplate.Component component = new WhatsAppTemplate.Component();
                        component.setType(componentNode.getType());
                        component.setText(componentNode.getText());
                        component.setFormat(componentNode.getFormat());
                        components.add(component);
                    }
                    template.setComponents(components);
                    templates.add(template);
                }
                return Mono.just(templates);
            }
            catch (Exception e) {
                log.error("Error parsing templates", (Throwable)e);
                return Mono.error((Throwable)new RuntimeException("Error parsing templates"));
            }
        });
    }

    public Mono<WhatsAppTemplate> getTemplateById(String id) {
        Mono monoTemplate = this.getTemplatesV2().flatMapMany(Flux::fromIterable).filter(template -> template.getId().equals(id)).next().switchIfEmpty(Mono.error((Throwable)new TemplateNotFoundException(id)));
        return monoTemplate.flatMap(tem -> this.obtenerIdImagen(tem.getId()).switchIfEmpty(Mono.just((Object)"S/N")).flatMap(imgUrl -> {
            if (imgUrl.equals("S/N")) {
                return Mono.just((Object)tem);
            }
            tem.setFileUrl(imgUrl);
            return Mono.just((Object)tem);
        }));
    }

    private String validatePhoneNumber(String phoneNumber) {
        if (((String)(phoneNumber = ((String)phoneNumber).replace(" ", ""))).startsWith("+")) {
            phoneNumber = ((String)phoneNumber).replace("+", "");
        }
        if (((String)phoneNumber).startsWith("0")) {
            phoneNumber = "593" + ((String)phoneNumber).substring(1);
        }
        return phoneNumber;
    }

    private static String cleanString(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[\\t\\n\\r]", " ").replaceAll("\\s{2,}", " ").trim();
    }

    public Mono<Void> sendMessageFromTemplate(String pNumber, String templateName, String language, List<String> parameters, String canal, String template_completo, String categoria) {
        log.info("Information template with channel {}, {}", (Object)canal, (Object)categoria);
        List scapedParameters = parameters.stream().map(TemplateServiceImpl::cleanString).collect(Collectors.toList());
        log.info("Parameters: {}", scapedParameters);
        String phoneNumber = this.validatePhoneNumber(pNumber);
        String canalDefecto = this.env.getProperty("canal.callback.default");
        String cobranzas = this.env.getProperty("canal.callback.cobranzas");
        String ventas = this.env.getProperty("canal.callback.ventas");
        String canal_asesor = switch (canal) {
            case "1" -> cobranzas;
            case "2" -> ventas;
            default -> canalDefecto;
        };
        log.info("Canal asesor: " + canal_asesor);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("messaging_product", "whatsapp");
        payload.put("to", phoneNumber);
        payload.put("type", "template");
        HashMap<String, Object> template = new HashMap<String, Object>();
        template.put("name", templateName);
        template.put("language", Map.of("code", language));
        template.put("components", List.of(Map.of("type", "body", "parameters", scapedParameters.stream().map(param -> Map.of("type", "text", "text", param)).collect(Collectors.toList()))));
        payload.put("template", template);
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(phoneNumber, "whatsapp", template_completo, StatusUtil.ST_THINKAGENT, "CAMPANA", "User");
        return this.whatsAppService.sendMessageTemplateToWhatsAppAPI(payload).flatMap(response -> {
            log.info("Response from WhatsApp API: {}", response);
            return this.stateConversationService.validateAndUpdateChatFromMetaTemplate(phoneNumber, canal_asesor, template_completo, categoria).then(this.historyConversationService.save(userHistoryConversation)).doOnError(e -> log.error("ERROR AL CAMBIAR EL ESTADO", e));
        }).doOnError(e -> {
            log.error("Error sending message to " + phoneNumber + ": " + e.getMessage());
            if (e instanceof WebClientResponseException) {
                WebClientResponseException webClientResponseException = (WebClientResponseException)e;
                String errorBody = webClientResponseException.getResponseBodyAsString();
                log.error("Error body from WhatsApp API: {}", (Object)errorBody);
            }
            CampaignModel camp = new CampaignModel();
            camp.setConversationId(phoneNumber);
            camp.setMessageTemplate(template_completo);
            camp.setCategoria(categoria);
            camp.setCanal(canal_asesor);
            camp.setSend(Boolean.valueOf(false));
            this.campaignMessageDAO.save(camp).subscribe();
        });
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        return this.whatsAppService.getConversationSummary(fecha_inicio, fecha_fin);
    }

    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.campaignMessageDAO.getAllConversationIncident().map(campaignList -> {
            campaignList.forEach(campaign -> {
                String title = (String)CHANNEL_TITLES.get(campaign.getCanal());
                if (title != null) {
                    campaign.setCanal(title);
                }
            });
            return campaignList;
        });
    }

    public Mono<Void> sendMessageFromTemplate(WhatsAppTemplateRequest request) {
        try {
            ArrayList<ComponentWhatsapp> components = new ArrayList<ComponentWhatsapp>();
            ComponentWhatsapp headerCompoent = request.generarHeaderComponent(request.getHeader());
            if (headerCompoent != null) {
                components.add(headerCompoent);
            }
            ComponentWhatsapp bodyComponent = request.generarBodyComponent(request.getBody());
            log.info("Body component: {}", (Object)bodyComponent);
            if (bodyComponent != null) {
                components.add(bodyComponent);
            }
            TemplateWhatsApp template = new TemplateWhatsApp(request.getTemplateName(), components, request.getLanguage());
            String phoneNumber = this.validatePhoneNumber(request.getNumber());
            WhatsAppCampaignModel campaign = new WhatsAppCampaignModel(phoneNumber, template);
            String campaignJson = this.objectMapper.writeValueAsString((Object)campaign);
            log.info("Sending template message to numbers, {}", (Object)campaignJson);
            log.info("Sending template message to numbers");
            String canal_asesor = this.getCanal(request.getCanal());
            HistoryConversationItem userHistoryConversation = new HistoryConversationItem(phoneNumber, "whatsapp", request.getTemplate(), StatusUtil.ST_THINKAGENT, "CAMPANA", "User");
            return this.whatsAppService.sendMessageTemplateToWhatsAppAPIV2((Object)campaign).flatMap(response -> {
                log.info("Response from WhatsApp API: {}", response);
                return this.stateConversationService.validateAndUpdateChatFromMetaTemplate(phoneNumber, canal_asesor, request.getTemplate(), request.getCategoria()).then(this.historyConversationService.save(userHistoryConversation)).doOnError(e -> log.error("ERROR AL CAMBIAR EL ESTADO", e));
            }).doOnError(e -> {
                log.error("Error sending message to " + phoneNumber + ": " + e.getMessage());
                if (e instanceof WebClientResponseException) {
                    WebClientResponseException webClientResponseException = (WebClientResponseException)e;
                    String errorBody = webClientResponseException.getResponseBodyAsString();
                    log.error("Error body from WhatsApp API: {}", (Object)errorBody);
                }
                CampaignModel camp = new CampaignModel();
                camp.setConversationId(phoneNumber);
                camp.setMessageTemplate(request.getTemplate());
                camp.setCategoria(request.getCategoria());
                camp.setCanal(canal_asesor);
                camp.setSend(Boolean.valueOf(false));
                this.campaignMessageDAO.save(camp).subscribe();
            });
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
    }

    private String getCanal(String codigoCanal) {
        String canalDefecto = this.env.getProperty("canal.callback.default");
        String cobranzas = this.env.getProperty("canal.callback.cobranzas");
        String ventas = this.env.getProperty("canal.callback.ventas");
        switch (codigoCanal) {
            case "1": {
                return cobranzas;
            }
            case "2": {
                return ventas;
            }
        }
        return canalDefecto;
    }

    public Mono<ImagenModel> guardarUrlImagen(String id, String url) {
        ImagenModel imagen = new ImagenModel(id, url);
        return this.imagenRepository.save((Object)imagen);
    }

    public Mono<String> obtenerIdImagen(String id) {
        return this.imagenRepository.findByIdImagen(id).map(ImagenModel::getUrlImagen);
    }

    public TemplateServiceImpl(ApiWhatsAppService whatsAppService, StateConversationService stateConversationService, HistoryConversationItemService historyConversationService, ObjectMapper objectMapper, Environment env, CampaignMessageDAO campaignMessageDAO, ImagenMessageRepository imagenRepository) {
        this.whatsAppService = whatsAppService;
        this.stateConversationService = stateConversationService;
        this.historyConversationService = historyConversationService;
        this.objectMapper = objectMapper;
        this.env = env;
        this.campaignMessageDAO = campaignMessageDAO;
        this.imagenRepository = imagenRepository;
    }

    static {
        CHANNEL_TITLES.put("45fe8e1646aa61-e0901b1abd129c-68dc0ee3ddd74d", "ATENCI\u00d3N CLIENTE");
        CHANNEL_TITLES.put("6bf1a1f91cd9b8-b7720508e294b9-0d07ec71d2be65", "COBRANZAS");
        CHANNEL_TITLES.put("4f6e419d3a8b25-6dbdcf5ab9486b-62ec01ee0ab6bc", "VENTAS");
        CHANNEL_TITLES.put("62e80355d4463f-bf7e415142af71-5e24020cef4625", "SERVICIO T\u00c9CNICO");
    }
}

