/*
 * Decompiled with CFR 0.152.
 */
package com.meta.tws2.client.tsa.service;

import com.meta.tws2.client.tsa.TsaApiService;
import com.meta.tws2.data.tsa.RequestMessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaApiServiceImple
implements TsaApiService {
    private static final Logger log = LoggerFactory.getLogger(TsaApiServiceImple.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<String> sendMesssageToAsesor(RequestMessageModel data, String callbackId) {
        log.info("CONNECTING TO TSA {}", (Object)data);
        String API_URL = this.env.getProperty("tsa.api.url.messages").replace("{channel}", callbackId);
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)data).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)response);
        });
    }

    public TsaApiServiceImple(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

