/*
 * Decompiled with CFR 0.152.
 */
package com.meta.tws2.Repository.Services;

import com.meta.tws2.DTO.DailyCountDTO;
import com.meta.tws2.Documents.CampaignModel;
import com.meta.tws2.Repository.CampaignMessageReposotory;
import com.meta.tws2.Repository.CampaignReactiveReportRepository;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class CampaignMessageDAO {
    private static final Logger log = LoggerFactory.getLogger(CampaignMessageDAO.class);
    private final CampaignMessageReposotory campaignMessageReposotory;
    private final CampaignReactiveReportRepository campaignReactiveReportRepository;

    public Mono<CampaignModel> save(CampaignModel campaignModel) {
        return this.campaignMessageReposotory.save((Object)campaignModel);
    }

    public Mono<String> findLastMessageTemplateByConversationId(String conversationId) {
        return this.campaignMessageReposotory.findFirstByConversationIdOrderByCreatedAtDesc(conversationId).doOnNext(campaignModel -> log.info("CampaignModel encontrado: {}", campaignModel)).doOnSuccess(result -> log.info("Flujo completado con \u00e9xito: {}", result)).doOnError(error -> log.error("Error en el flujo: {}", (Object)error.getMessage())).map(CampaignModel::getMessageTemplate).defaultIfEmpty((Object)"");
    }

    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.campaignMessageReposotory.findBySendFalse().collectList();
    }

    public Flux<DailyCountDTO> obtenerReporteDiario(LocalDate inicio, LocalDate fin) {
        return this.campaignReactiveReportRepository.getDailyCounts(inicio, fin);
    }

    public CampaignMessageDAO(CampaignMessageReposotory campaignMessageReposotory, CampaignReactiveReportRepository campaignReactiveReportRepository) {
        this.campaignMessageReposotory = campaignMessageReposotory;
        this.campaignReactiveReportRepository = campaignReactiveReportRepository;
    }
}

