/*
 * Decompiled with CFR 0.152.
 */
package com.web.motopower.service.impl;

import com.web.motopower.client.botpress.service.ApiBotpressService;
import com.web.motopower.data.tsa.RequestMessageModel;
import com.web.motopower.service.HistoryConversationItemService;
import com.web.motopower.service.StateConversationService;
import com.web.motopower.service.ThinkAgentService;
import com.web.motopower.service.WebhookService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationItemService;
    private final ThinkAgentService thinkAgentService;
    private final ApiBotpressService apiBotpressService;
    private final Environment env;

    public Mono<ResponseEntity<?>> identificarWebhook(RequestMessageModel request) {
        try {
            log.info("Procesando webhook: {}", (Object)request);
            return this.processWebhookMessage(request).flatMap(response -> {
                log.info("Respuesta procesada: {}", response);
                Map<String, String> map = Map.of("status", "ok");
                return Mono.just((Object)ResponseEntity.ok(map));
            });
        }
        catch (Exception e) {
            log.error("Error al procesar el mensaje", (Throwable)e);
            return Mono.just((Object)ResponseEntity.ok((Object)"Error al procesar el mensaje"));
        }
    }

    private Mono<ResponseEntity<?>> processWebhookMessage(RequestMessageModel request) {
        log.info("Recibiendo mensaje de webhook: {}", (Object)request);
        return this.stateConversationService.validateConversationAndGetStatusConversation(request).flatMap(status -> {
            log.info("Estado de la conversaci\u00f3n: {}", status);
            return this.handleStatusSwitch(status, request).then(this.historyConversationItemService.saveConversationFromWebhookWeb(request, status));
        }).onErrorResume(e -> {
            log.error("Error procesando el mensaje: {}", (Object)e.getMessage(), e);
            return Mono.empty();
        }).map(response -> ResponseEntity.ok((Object)response));
    }

    private Mono<RequestMessageModel> handleStatusSwitch(String status, RequestMessageModel request) {
        switch (status) {
            case "NORMAL": {
                return this.handleNormalCase(request);
            }
            case "ASESOR": {
                return this.handleAsesorCase(request);
            }
            case "THINKAGENT": {
                return this.handleAsesorCase(request);
            }
        }
        return Mono.just((Object)request);
    }

    private Mono<RequestMessageModel> handleNormalCase(RequestMessageModel request) {
        log.info("Notificando mensaje a Botpress");
        String API_URL = this.env.getProperty("botpress.webhook.web");
        return this.apiBotpressService.notifyWebHook((Object)request, API_URL).flatMap(response -> {
            log.info("Respuesta de Botpress: {}", response);
            return Mono.empty();
        });
    }

    private Mono<RequestMessageModel> handleAsesorCase(RequestMessageModel requestMessageModel) {
        return this.thinkAgentService.sendMessageToTAS(requestMessageModel).flatMap(response -> {
            log.info("Respuesta de thinkagent: {}", response);
            return Mono.empty();
        });
    }

    public Mono<ResponseEntity<String>> sendMessageToWeb(RequestMessageModel requestMessageModel) {
        log.info("data de BotpressDTO {}", (Object)requestMessageModel);
        return this.thinkAgentService.sendMessageToWebFromTSA(requestMessageModel).flatMap(response -> {
            log.info("Mensaje enviado correctamente: {}", response);
            return Mono.just((Object)response);
        }).onErrorResume(e -> {
            log.error("Error al enviar el mensaje", e);
            return Mono.error((Throwable)e);
        });
    }

    public WebhookServiceImpl(StateConversationService stateConversationService, HistoryConversationItemService historyConversationItemService, ThinkAgentService thinkAgentService, ApiBotpressService apiBotpressService, Environment env) {
        this.stateConversationService = stateConversationService;
        this.historyConversationItemService = historyConversationItemService;
        this.thinkAgentService = thinkAgentService;
        this.apiBotpressService = apiBotpressService;
        this.env = env;
    }
}

