/*
 * Decompiled with CFR 0.152.
 */
package com.web.motopower.service.impl;

import com.web.motopower.Documents.HistoryConversationItem;
import com.web.motopower.Repository.Services.ConversationDAO;
import com.web.motopower.client.botpress.service.ApiBotpressService;
import com.web.motopower.client.tsa.TsaApiService;
import com.web.motopower.data.dto.BotpressDTO;
import com.web.motopower.data.tsa.RequestMessageModel;
import com.web.motopower.service.HistoryConversationItemService;
import com.web.motopower.service.StateConversationService;
import com.web.motopower.service.ThinkAgentService;
import com.web.motopower.utils.MessageTypeUtils;
import com.web.motopower.utils.PlatformEnum;
import com.web.motopower.utils.StatusUtil;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final TsaApiService tsaApiService;
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationItemService;
    private final Environment env;
    private final ConversationDAO conversationDAO;
    private final ApiBotpressService apiBotpressService;

    public Mono<ResponseEntity<String>> sendMessageToTAS(RequestMessageModel requestMessageModel) {
        log.info("Data message meta: {}", (Object)requestMessageModel);
        String userId = requestMessageModel.getId();
        RequestMessageModel.Payload payload = requestMessageModel.getPayload();
        requestMessageModel.setId(userId);
        requestMessageModel.setType("message");
        requestMessageModel.setPayload(payload);
        requestMessageModel.setChannel(PlatformEnum.WEB.getPlatform());
        return this.sendMessage(requestMessageModel);
    }

    private Mono<ResponseEntity<String>> sendMessage(RequestMessageModel requestMessageModel) {
        return this.conversationDAO.getCallbackByConversationId(requestMessageModel.getId()).defaultIfEmpty((Object)this.env.getProperty("tsa.canal.callback.default")).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId));
    }

    public Mono<ResponseEntity<String>> sendMessageToWebFromTSA(RequestMessageModel requestMessageModel) {
        return this.processMessageToTsa(requestMessageModel).flatMap(response -> {
            log.info("Message sent to messenger: {} ", response);
            HistoryConversationItem historyConversationItem = new HistoryConversationItem(requestMessageModel.getId(), PlatformEnum.WEB.getPlatform(), requestMessageModel.getPayload().getContent(), StatusUtil.ST_THINKAGENT, StatusUtil.ST_THINKAGENT, requestMessageModel.getNick());
            return this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), StatusUtil.ST_THINKAGENT).then(this.historyConversationItemService.save(historyConversationItem)).flatMap(savedItem -> {
                if (savedItem == null) {
                    return Mono.error((Throwable)new RuntimeException("Error al guardar el hist\u00f3rico de conversaci\u00f3n"));
                }
                log.info("Historial de conversaci\u00f3n guardado");
                return Mono.just((Object)response);
            }).onErrorResume(error -> {
                log.error("Error guardando historial de conversaci\u00f3n", error);
                return Mono.just((Object)ResponseEntity.status((int)500).body((Object)"Error guardando historial"));
            });
        });
    }

    private Mono<ResponseEntity<String>> processMessageToTsa(RequestMessageModel requestMessageModel) {
        String apiUrl = this.env.getProperty("botpress.webhook.web");
        BotpressDTO dtoBotpressModel = new BotpressDTO(requestMessageModel.getId(), requestMessageModel.getChannel(), requestMessageModel.getId(), requestMessageModel.getNick(), requestMessageModel.getPayload().getType(), requestMessageModel.getPayload().getContent());
        String message = requestMessageModel.getPayload().getContent();
        String typeMessage = requestMessageModel.getPayload().getType();
        if (null != message && typeMessage.equals(MessageTypeUtils.TYPE_TEXT)) {
            if (message.contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                return this.apiBotpressService.notifyWebHook((Object)dtoBotpressModel, apiUrl).flatMap(messageMetaId -> Mono.just((Object)ResponseEntity.ok((Object)messageMetaId)));
            }
            if (message.contains("ESTE MENSAJE SE HA ELIMINADO")) {
                log.info("Mensaje de eliminaci\u00f3n ignorado");
                return Mono.just((Object)ResponseEntity.ok((Object)UUID.randomUUID().toString()));
            }
        }
        return this.apiBotpressService.notifyWebHook((Object)dtoBotpressModel, apiUrl).flatMap(messageMetaId -> Mono.just((Object)ResponseEntity.ok((Object)messageMetaId)));
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(RequestMessageModel requestMessageModel, String callbackId) {
        return this.tsaApiService.sendMesssageToAsesor(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"));
        });
    }

    public Mono<ResponseEntity<String>> redirectLhiaConversationToTSA(RequestMessageModel requestMessageModel) {
        String status = StatusUtil.ST_THINKAGENT;
        String callbackId = this.env.getProperty("tsa.canal.callback.ventas");
        requestMessageModel.setChannel(PlatformEnum.WEB.getPlatform());
        return this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), status).then(Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")));
        });
    }

    public ThinkAgentServiceImpl(TsaApiService tsaApiService, StateConversationService stateConversationService, HistoryConversationItemService historyConversationItemService, Environment env, ConversationDAO conversationDAO, ApiBotpressService apiBotpressService) {
        this.tsaApiService = tsaApiService;
        this.stateConversationService = stateConversationService;
        this.historyConversationItemService = historyConversationItemService;
        this.env = env;
        this.conversationDAO = conversationDAO;
        this.apiBotpressService = apiBotpressService;
    }
}

