/*
 * Decompiled with CFR 0.152.
 */
package com.web.motopower.interceptors;

import com.web.motopower.exceptions.CustomException;
import com.web.motopower.exceptions.TemplateNotFoundException;
import com.web.motopower.utils.ApiResponse;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGlobalException(Exception ex, ServerWebExchange exchange) {
        log.error("ERROR", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGlobalException(RuntimeException ex, ServerWebExchange exchange) {
        log.error("ERROR", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={TemplateNotFoundException.class})
    public ResponseEntity<Map<String, String>> handleTemplateNotFoundException(TemplateNotFoundException ex) {
        HashMap<String, String> errorResponse = new HashMap<String, String>();
        errorResponse.put("message", ex.getMessage());
        return new ResponseEntity(errorResponse, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={CustomException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGlobalException(CustomException ex, ServerWebExchange exchange) {
        ApiResponse response = ApiResponse.error((int)ex.getHttpStatus().value(), (String)ex.getMessage());
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)ex.getHttpStatus()));
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleAsyncRequestTimeoutException(ServerWebExchange exchange) {
        ApiResponse response = ApiResponse.error((int)HttpStatus.REQUEST_TIMEOUT.value(), (String)"La solicitud ha tardado demasiado tiempo en procesarse.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.REQUEST_TIMEOUT));
    }
}

