/*
 * Decompiled with CFR 0.152.
 */
package com.web.motopower.helpers;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class HistoryConversationItemHelper {
    final String collectionHistoryConversation = "history_conversation";
    final String collectionHistoryConversationItem = "history_conversation_item";
    private final ReactiveMongoTemplate reactiveMongoTemplate;

    public HistoryConversationItemHelper(ReactiveMongoTemplate reactiveMongoTemplate) {
        this.reactiveMongoTemplate = reactiveMongoTemplate;
    }

    public Flux<Map<String, Object>> getMessagesCountByDay(String startDateParam, String endDateParam) {
        LocalDate startDate = LocalDate.parse(startDateParam).minusDays(1L);
        LocalDate endDate = LocalDate.parse(endDateParam).plusDays(1L);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"createdAt").gte((Object)startDate.atStartOfDay()).lt((Object)endDate.atStartOfDay())), Aggregation.project((String[])new String[0]).andExpression("dateToString('%Y-%m-%d', createdAt)", new Object[0]).as("dateOnly"), Aggregation.group((String[])new String[]{"dateOnly"}).count().as("count"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"})});
        return this.reactiveMongoTemplate.aggregate(aggregation, "history_conversation_item", Map.class).filter(map -> this.excludeStartAndEndDates(map, startDate, endDate)).cast(Map.class);
    }

    public Mono<Integer> getUsersCountByDay(String startDateParam, String endDateParam) {
        LocalDate startDate = LocalDate.parse(startDateParam).minusDays(1L);
        LocalDate endDate = LocalDate.parse(endDateParam).plusDays(1L);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"updatedAt").gte((Object)startDate.atStartOfDay()).lt((Object)endDate.atStartOfDay())), Aggregation.project((String[])new String[0]).andExpression("dateToString('%Y-%m-%d', updatedAt)", new Object[0]).as("dateOnly"), Aggregation.group((String[])new String[]{"dateOnly"}).count().as("count"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"})});
        return this.reactiveMongoTemplate.aggregate(aggregation, "history_conversation", Map.class).filter(map -> this.excludeStartAndEndDates(map, startDate, endDate)).map(data -> (Integer)data.get("count")).reduce((Object)0, Integer::sum);
    }

    public Mono<Integer> getMessagesCountByRoleAndDateRange(String startDateParam, String endDateParam, List<String> roles) {
        LocalDate startDate = LocalDate.parse(startDateParam).minusDays(1L);
        LocalDate endDate = LocalDate.parse(endDateParam).plusDays(1L);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"createdAt").gte((Object)startDate.atStartOfDay()).lt((Object)endDate.atStartOfDay()).and("rol").in(roles)), Aggregation.project((String[])new String[0]).andExpression("dateToString('%Y-%m-%d', createdAt)", new Object[0]).as("dateOnly"), Aggregation.group((String[])new String[]{"dateOnly"}).count().as("count"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"})});
        return this.reactiveMongoTemplate.aggregate(aggregation, "history_conversation_item", Map.class).filter(map -> this.excludeStartAndEndDates(map, startDate, endDate)).map(data -> (Integer)data.get("count")).reduce((Object)0, Integer::sum);
    }

    private boolean excludeStartAndEndDates(Map<String, Object> map, LocalDate startDate, LocalDate endDate) {
        String dateOnly = (String)map.get("_id");
        LocalDate mapDate = LocalDate.parse(dateOnly);
        return !mapDate.equals(startDate) && !mapDate.equals(endDate);
    }
}

