/*
 * Decompiled with CFR 0.152.
 */
package com.web.motopower.controller;

import com.web.motopower.data.tsa.RequestMessageModel;
import com.web.motopower.service.WebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={""})
public class WebHookController {
    private static final Logger log = LoggerFactory.getLogger(WebHookController.class);
    private final WebhookService webhookService;

    @PostMapping(value={"/api-key/ms/messages"})
    public Mono<ResponseEntity<?>> receiveMessage(@RequestBody RequestMessageModel requestMessageModel) {
        System.out.println("Received message: " + requestMessageModel);
        return this.webhookService.identificarWebhook(requestMessageModel);
    }

    @PostMapping(value={"/webhook/response"})
    public Mono<ResponseEntity<String>> responseMessage(@RequestBody RequestMessageModel requestMessageModel) {
        System.out.println("Response message: " + requestMessageModel);
        return this.webhookService.sendMessageToWeb(requestMessageModel);
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebHookController)) {
            return false;
        }
        WebHookController other = (WebHookController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebhookService this$webhookService = this.getWebhookService();
        WebhookService other$webhookService = other.getWebhookService();
        return !(this$webhookService == null ? other$webhookService != null : !this$webhookService.equals(other$webhookService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebHookController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebhookService $webhookService = this.getWebhookService();
        result = result * 59 + ($webhookService == null ? 43 : $webhookService.hashCode());
        return result;
    }

    public String toString() {
        return "WebHookController(webhookService=" + this.getWebhookService() + ")";
    }

    public WebHookController(WebhookService webhookService) {
        this.webhookService = webhookService;
    }
}

