/*
 * Decompiled with CFR 0.152.
 */
package com.web.motopower.auth;

import com.web.motopower.auth.JwtAuthConverter;
import com.web.motopower.interceptors.CustomAccessDeniedHandler;
import com.web.motopower.interceptors.CustomAuthenticationEntryPoint;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.web.server.WebFilter;
import reactor.util.context.ContextView;

@Configuration
@EnableWebFluxSecurity
public class WebSecurityConfig {
    @Value(value="${spring.webflux.base-path}")
    private String basePath;
    private static String PATH_API_KEY = "api-key/ms";
    private final JwtAuthConverter jwtAuthConverter;
    private final CustomAuthenticationEntryPoint customAuthenticationEntryPoint;
    private final CustomAccessDeniedHandler customAccessDeniedHandler;
    private final Environment env;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter, CustomAuthenticationEntryPoint customAuthenticationEntryPoint, CustomAccessDeniedHandler customAccessDeniedHandler, Environment environment) {
        this.jwtAuthConverter = jwtAuthConverter;
        this.customAuthenticationEntryPoint = customAuthenticationEntryPoint;
        this.customAccessDeniedHandler = customAccessDeniedHandler;
        this.env = environment;
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        return http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((ServerAccessDeniedHandler)this.customAccessDeniedHandler)).authorizeExchange(authorize -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorize.pathMatchers(new String[]{"/actuator/info"})).permitAll().pathMatchers(new String[]{"/actuator/health"})).permitAll().pathMatchers(new String[]{"/webhook/response"})).permitAll().pathMatchers(new String[]{"/chat-bp/js/script_motopower.js"})).permitAll().pathMatchers(new String[]{this.basePath + PATH_API_KEY + "/**"})).authenticated().anyExchange().authenticated()).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.jwtAuthConverter))).csrf(ServerHttpSecurity.CsrfSpec::disable).addFilterAt(this.apiKeyAuthenticationFilter(), SecurityWebFiltersOrder.AUTHENTICATION).build();
    }

    private WebFilter apiKeyAuthenticationFilter() {
        return (exchange, chain) -> {
            String pathApi;
            String path = exchange.getRequest().getURI().getPath();
            if (path.startsWith(pathApi = this.basePath + PATH_API_KEY + "/")) {
                String apiKey = exchange.getRequest().getHeaders().getFirst(this.env.getProperty("API_KEY_HEADER"));
                if (this.env.getProperty("API_KEY").equals(apiKey)) {
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"apiKeyUser", null, List.of());
                    return chain.filter(exchange).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)auth));
                }
                return this.customAuthenticationEntryPoint.commence(exchange, (AuthenticationException)new /* Unavailable Anonymous Inner Class!! */);
            }
            return chain.filter(exchange);
        };
    }
}

