/*
 * Decompiled with CFR 0.152.
 */
package com.web.marci.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.web.marci.utils.MessageTypeUtils;
import com.web.marci.web.data.messages.extractData.ExtractDataEntry;
import com.web.marci.web.data.messages.extractData.MediaFileType;
import com.web.marci.web.data.messages.extractData.MessageData;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static String truncateString(String input, int limit) {
        if (input != null && input.length() > limit) {
            return input.substring(0, limit);
        }
        return input;
    }

    public static String identifyMessageType(JsonNode messagingNode) {
        if (messagingNode.has(MessageTypeUtils.DELIVERY_TYPE)) {
            return MessageTypeUtils.DELIVERY_TYPE;
        }
        if (messagingNode.has(MessageTypeUtils.READ_TYPE)) {
            return MessageTypeUtils.DELIVERY_TYPE;
        }
        if (messagingNode.has(MessageTypeUtils.POSTBACK_TYPE)) {
            return MessageTypeUtils.POSTBACK_MESSAGE;
        }
        if (messagingNode.has(MessageTypeUtils.MESSAGE_TYPE)) {
            JsonNode messageNode = messagingNode.get(MessageTypeUtils.MESSAGE_TYPE);
            if (messageNode.has("is_echo")) {
                return MessageTypeUtils.DELIVERY_TYPE;
            }
            if (messageNode.has(MessageTypeUtils.TEXT_TYPE) && messageNode.has(MessageTypeUtils.REPLY_TYPE)) {
                return MessageTypeUtils.REPLY_MESSAGE;
            }
            if (messageNode.has(MessageTypeUtils.TEXT_TYPE)) {
                return MessageTypeUtils.TEXT_MESSAGE;
            }
            if (messageNode.has(MessageTypeUtils.ATTACHMENTS_TYPE)) {
                return MessageTypeUtils.MEDIA_MESSAGE;
            }
        }
        return MessageTypeUtils.UNKNOWN;
    }

    public static List<ExtractDataEntry> parseEntries(JsonNode rootNode) {
        ArrayList<ExtractDataEntry> entries = new ArrayList<ExtractDataEntry>();
        if (rootNode.has("entry")) {
            for (JsonNode entryNode : rootNode.get("entry")) {
                if (!entryNode.has("messaging")) continue;
                for (JsonNode messagingNode : entryNode.get("messaging")) {
                    String messageType = Utils.identifyMessageType((JsonNode)messagingNode);
                    MessageData messaging = Utils.mapToMessagingweb((JsonNode)messagingNode, (String)messageType);
                    ExtractDataEntry messageModelEntry = new ExtractDataEntry();
                    messageModelEntry.setMessageType(messageType);
                    messageModelEntry.setMessaging(messaging);
                    entries.add(messageModelEntry);
                }
            }
        }
        return entries;
    }

    public static MessageData mapToMessagingweb(JsonNode messagingNode, String type) {
        MessageData messaging = new MessageData();
        messaging.setSenderId(messagingNode.path("sender").path("id").asText());
        messaging.setRecipientId(messagingNode.path("recipient").path("id").asText());
        if (messagingNode.has("message")) {
            JsonNode messageNode = messagingNode.get("message");
            messaging.setMessageId(messageNode.path("mid").asText());
            if (type.equals(MessageTypeUtils.TEXT_MESSAGE) || type.equals(MessageTypeUtils.REPLY_MESSAGE)) {
                messaging.setMessage(messageNode.path("text").asText());
            }
            if (type.equals(MessageTypeUtils.REPLY_MESSAGE) && messageNode.has(MessageTypeUtils.REPLY_TYPE)) {
                messaging.setReplyTo(messageNode.path("reply_to").path("mid").asText());
            }
            if (type.equals(MessageTypeUtils.MEDIA_MESSAGE)) {
                ArrayList<MediaFileType> fileUrls = new ArrayList<MediaFileType>();
                for (JsonNode attachment : messageNode.path("attachments")) {
                    if (!attachment.has("payload") || !attachment.path("payload").has("url")) continue;
                    String typeAttachment = attachment.path("type").asText();
                    String urlAttachment = attachment.path("payload").path("url").asText();
                    fileUrls.add(new MediaFileType(typeAttachment, urlAttachment));
                }
                messaging.setFiles(fileUrls);
            }
        } else if (messagingNode.has(MessageTypeUtils.POSTBACK_TYPE)) {
            messaging.setMessageId(messagingNode.path("postback").path("mid").asText(""));
            messaging.setMessage(messagingNode.path("postback").path("payload").asText());
        }
        return messaging;
    }
}

