/*
 * Decompiled with CFR 0.152.
 */
package com.web.marci.service.impl;

import com.web.marci.Documents.StateConversation;
import com.web.marci.Repository.Services.ConversationDAO;
import com.web.marci.data.tsa.RequestMessageModel;
import com.web.marci.service.StateConversationService;
import com.web.marci.utils.StatusUtil;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StateConversationServiceImpl
implements StateConversationService {
    private static final Logger log = LoggerFactory.getLogger(StateConversationServiceImpl.class);
    private final ConversationDAO conversationDAO;
    private final Environment env;

    public Mono<String> validateConversationAndGetStatusConversation(RequestMessageModel dataEntry) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.atencion");
        String conversationId = dataEntry.getId();
        return this.getStatusCoonversation(conversationId).defaultIfEmpty((Object)StatusUtil.ST_NORMAL).flatMap(status -> {
            String statusIdentified = this.validateMessageIfUserRequestAnEventStatus(dataEntry.getPayload().getContent());
            if (statusIdentified != null && statusIdentified.equals(StatusUtil.ST_ASESOR)) {
                log.info("SOLICITANDO EN MODO ASESOR: callbackId: {}, modo {}, usuario {}", new Object[]{defaultCallback, statusIdentified, conversationId});
                return this.getCallbackIdFromConversationId(conversationId).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                    log.info("callbackId: {}, modo {}, usuario {}", new Object[]{callbackId, statusIdentified, conversationId});
                    return this.updateConversation(conversationId, statusIdentified, callbackId).flatMap(conversation -> Mono.just((Object)conversation.getStateConversation()));
                });
            }
            return this.getCallbackIdFromConversationId(conversationId).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                log.info("callbackId: {}, modo {}, usuario {}", new Object[]{callbackId, statusIdentified, conversationId});
                return this.updateConversation(conversationId, statusIdentified == null ? status : statusIdentified, callbackId).flatMap(conversation -> Mono.just((Object)conversation.getStateConversation()));
            });
        });
    }

    private String validateMessageIfUserRequestAnEventStatus(String message) {
        log.info("Validando si requiere cambio de estado con el mensaje: {}", (Object)message);
        if (message != null) {
            String messageCleaned = message.replaceAll(" ", "").toUpperCase();
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_ASESOR)) {
                log.info("El usuario solicita hablar con un asesor");
                return StatusUtil.ST_ASESOR;
            }
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_LHIA)) {
                log.info("El usuario solicita hablar con lhia");
                return StatusUtil.ST_LHIA;
            }
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_FINALIZAR)) {
                log.info("El usuario solicita finalizar la conversaci\u00f3n");
                return StatusUtil.ST_FINALIZAR;
            }
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_CAMPANA)) {
                log.info("El usuario solicita hablar con campa\u00f1a");
                return StatusUtil.ST_CAMPANA;
            }
        }
        log.info("El mensaje no solicita un cambio de estado");
        return null;
    }

    public Mono<String> getStatusCoonversation(String conversationId) {
        return this.conversationDAO.getStatusConversationByConversationId(conversationId);
    }

    public Mono<String> getCallbackIdFromConversationId(String conversationId) {
        log.info("Obteniendo callbackId de la conversaci\u00f3n: {}", (Object)conversationId);
        return this.conversationDAO.getCallbackByConversationId(conversationId);
    }

    public Mono<StateConversation> updateConversation(String conversationId, String stateConversation, String callback) {
        return this.conversationDAO.existsByConversationId(conversationId).flatMap(exists -> {
            if (exists.booleanValue()) {
                log.warn("La conversacion existe, actualizando conversaci\u00f3n: {}, callback {}", (Object)conversationId, (Object)callback);
                return this.conversationDAO.findByConversationId(conversationId).flatMap(conversation -> {
                    conversation.setActive(Boolean.valueOf(true));
                    conversation.setStateConversation(stateConversation);
                    conversation.setUpdatedAt(LocalDateTime.now());
                    if (callback != null) {
                        conversation.setCallbackId(callback);
                    }
                    return this.conversationDAO.save(conversation);
                });
            }
            log.warn("La conversacion no existe, creando conversaci\u00f3n: {}", (Object)conversationId);
            StateConversation newConversation = new StateConversation(conversationId, stateConversation, callback);
            return this.conversationDAO.save(newConversation);
        });
    }

    public Mono<Void> updateStateByConversationId(String conversationId, String state) {
        return this.getStatusCoonversation(conversationId).flatMap(status -> this.getCallbackIdFromConversationId(conversationId).flatMap(callbackId -> this.validateAndUpdateChat(conversationId, state, callbackId).then()));
    }

    public Mono<Void> validateAndUpdateChat(String conversationId, String stateConversation, String callback) {
        System.out.println("cerrando");
        return this.conversationDAO.existsByConversationId(conversationId).flatMap(exists -> {
            log.warn("estado: {}", exists);
            if (exists.booleanValue()) {
                return this.conversationDAO.findByConversationId(conversationId).flatMap(conversation -> {
                    conversation.setActive(Boolean.valueOf(true));
                    conversation.setStateConversation(stateConversation);
                    conversation.setUpdatedAt(LocalDateTime.now());
                    if (callback != null) {
                        conversation.setCallbackId(callback);
                    }
                    return this.conversationDAO.save(conversation).then();
                });
            }
            StateConversation newConversation = callback == null ? new StateConversation(conversationId, stateConversation) : new StateConversation(conversationId, stateConversation, callback);
            return this.conversationDAO.save(newConversation).then();
        });
    }

    public Mono<Void> validateStateAsesor(String conversationId) {
        return this.getStatusCoonversation(conversationId).flatMap(status -> {
            if (!status.equals(StatusUtil.ST_ASESOR)) {
                return this.getCallbackIdFromConversationId(conversationId).flatMap(callbackId -> this.validateAndUpdateChat(conversationId, StatusUtil.ST_ASESOR, callbackId).then());
            }
            return Mono.empty();
        });
    }

    public Mono<Void> updateStateConversation(String conversationId, String event, String callback, String nick) {
        log.info("Actualizando conversaci\u00f3n: {}, estado: {}, callback: {}", new Object[]{conversationId, event, callback});
        switch (event = event.toUpperCase().trim().replace(" ", "")) {
            case "BOT": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, callback);
            }
            case "NORMAL": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, callback);
            }
            case "LHIA": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_LHIA, callback);
            }
            case "CAMPANA": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_CAMPANA, callback);
            }
            case "THINKAGENT": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_THINKAGENT, callback);
            }
        }
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_LHIA, callback);
    }

    public Mono<Void> validateAndUpdateChatFromMetaTemplate(String conversationId, String canalCallback, String campaignMessage, String categoria) {
        throw new UnsupportedOperationException("Unimplemented method 'validateAndUpdateChatFromMetaTemplate'");
    }

    public ConversationDAO getConversationDAO() {
        return this.conversationDAO;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateConversationServiceImpl)) {
            return false;
        }
        StateConversationServiceImpl other = (StateConversationServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ConversationDAO this$conversationDAO = this.getConversationDAO();
        ConversationDAO other$conversationDAO = other.getConversationDAO();
        if (this$conversationDAO == null ? other$conversationDAO != null : !this$conversationDAO.equals(other$conversationDAO)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateConversationServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationDAO $conversationDAO = this.getConversationDAO();
        result = result * 59 + ($conversationDAO == null ? 43 : $conversationDAO.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "StateConversationServiceImpl(conversationDAO=" + this.getConversationDAO() + ", env=" + this.getEnv() + ")";
    }

    public StateConversationServiceImpl(ConversationDAO conversationDAO, Environment env) {
        this.conversationDAO = conversationDAO;
        this.env = env;
    }
}

