/*
 * Decompiled with CFR 0.152.
 */
package com.web.marci.controller;

import com.web.marci.data.conversation.state.UpdateStateConversationRequest;
import com.web.marci.service.StateConversationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/state"})
public class StateController {
    private static final Logger log = LoggerFactory.getLogger(StateController.class);
    private final StateConversationService stateConversationService;
    private final Environment env;

    @GetMapping(value={"/message"})
    public Mono<String> getStateConversation() {
        return Mono.just((Object)"hola");
    }

    @PostMapping(value={"/updateStateConversation"})
    public Mono<ResponseEntity<Void>> updateStateConversation(@RequestBody UpdateStateConversationRequest request) {
        String nick;
        log.info("Conversation Update {}", (Object)request);
        String conversationId = request.getConversationId();
        String event = request.getEvent();
        String callbackId = request.getCallbackId() != null ? request.getCallbackId() : this.env.getProperty("tsa.canal.callback.atencion");
        String string = nick = request.getNick() != null ? request.getNick() : "N/A";
        if (conversationId != null && event != null) {
            return this.stateConversationService.updateStateConversation(conversationId, event, callbackId, nick).then(Mono.just((Object)ResponseEntity.ok().build()));
        }
        return Mono.just((Object)ResponseEntity.badRequest().build());
    }

    public StateConversationService getStateConversationService() {
        return this.stateConversationService;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateController)) {
            return false;
        }
        StateController other = (StateController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        StateConversationService this$stateConversationService = this.getStateConversationService();
        StateConversationService other$stateConversationService = other.getStateConversationService();
        if (this$stateConversationService == null ? other$stateConversationService != null : !this$stateConversationService.equals(other$stateConversationService)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StateConversationService $stateConversationService = this.getStateConversationService();
        result = result * 59 + ($stateConversationService == null ? 43 : $stateConversationService.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "StateController(stateConversationService=" + this.getStateConversationService() + ", env=" + this.getEnv() + ")";
    }

    public StateController(StateConversationService stateConversationService, Environment env) {
        this.stateConversationService = stateConversationService;
        this.env = env;
    }
}

