/*
 * Decompiled with CFR 0.152.
 */
package com.web.marci.client.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class WebClientUtils {
    private static final Logger log = LoggerFactory.getLogger(WebClientUtils.class);

    public static <T> Mono<ResponseEntity<T>> handleWebClientResponse(WebClient.RequestHeadersSpec<?> requestSpec, Class<T> responseType, String logContext) {
        return requestSpec.exchangeToMono(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                return response.toEntity(responseType).doOnSuccess(res -> log.info("{} - Success!", (Object)logContext));
            }
            return response.bodyToMono(String.class).flatMap(errorBody -> {
                log.error("{} - Error response. Status: {}, Body: {}", new Object[]{logContext, response.statusCode(), errorBody});
                return Mono.empty();
            });
        }).onErrorResume(error -> {
            log.error("{} - Exception: ", (Object)logContext, error);
            return Mono.empty();
        });
    }
}

