/*
 * Decompiled with CFR 0.152.
 */
package com.web.marci.Repository.Services;

import com.web.marci.Documents.HistoryConversation;
import com.web.marci.Documents.StateConversation;
import com.web.marci.Repository.HistoryConversationRepository;
import com.web.marci.Repository.StateConversationRepository;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ConversationDAO {
    private final StateConversationRepository stateConversationRepository;
    private final HistoryConversationRepository historyConversationRepository;

    public Mono<String> getStatusConversationByConversationId(String conversationId) {
        return this.stateConversationRepository.findStateConversationByConversationId(conversationId).map(StateConversation::getStateConversation);
    }

    public Mono<String> getNameByConversationId(String conversationId) {
        return this.historyConversationRepository.findByIdPlatform(conversationId).map(HistoryConversation::getNick);
    }

    public Mono<String> getCallbackByConversationId(String conversationId) {
        return this.stateConversationRepository.getCallbackByConversationId(conversationId).map(StateConversation::getCallbackId);
    }

    public Mono<Boolean> existsByConversationId(String conversationId) {
        return this.stateConversationRepository.existsByConversationId(conversationId);
    }

    public Mono<StateConversation> findByConversationId(String conversationId) {
        return this.stateConversationRepository.findByConversationId(conversationId);
    }

    public Mono<StateConversation> save(StateConversation stateConversation) {
        return this.stateConversationRepository.save((Object)stateConversation);
    }

    public ConversationDAO(StateConversationRepository stateConversationRepository, HistoryConversationRepository historyConversationRepository) {
        this.stateConversationRepository = stateConversationRepository;
        this.historyConversationRepository = historyConversationRepository;
    }
}

