/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.web.reactive.function.client.WebClientResponseException;

public class ErrorParserUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String extractErrorMessage(Throwable e) {
        if (e instanceof WebClientResponseException) {
            WebClientResponseException ex = (WebClientResponseException)e;
            try {
                JsonNode root = mapper.readTree(ex.getResponseBodyAsString());
                String message = root.path("error").path("message").asText("Error desconocido");
                String detail = root.path("error").path("error_data").path("details").asText(null);
                return detail != null ? message + " - " + detail : message;
            }
            catch (Exception parseEx) {
                return "No se pudo parsear el error: " + parseEx.getMessage();
            }
        }
        return e.getMessage();
    }
}

