/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import java.util.Map;
import org.springframework.core.env.Environment;

public class CanalMapper {
    private static final Map<String, String> CHANNEL_TITLES = Map.of("45fe8e1646aa61-e0901b1abd129c-68dc0ee3ddd74d", "ATENCI\u00d3N CLIENTE", "6bf1a1f91cd9b8-b7720508e294b9-0d07ec71d2be65", "COBRANZAS", "4f6e419d3a8b25-6dbdcf5ab9486b-62ec01ee0ab6bc", "VENTAS", "62e80355d4463f-bf7e415142af71-5e24020cef4625", "SERVICIO T\u00c9CNICO");

    public static String getTitle(String canalCode) {
        return CHANNEL_TITLES.getOrDefault(canalCode, canalCode);
    }

    public static String getCanal(String codeCanal, Environment env) {
        String defaultCanal = env.getProperty("tsa.canal.callback.default", "CANAL_DESCONOCIDO");
        return switch (codeCanal) {
            case "1" -> env.getProperty("canal.callback.atencion_cliente", defaultCanal);
            case "2" -> env.getProperty("canal.callback.cobranzas", defaultCanal);
            case "3" -> env.getProperty("canal.callback.servicio_tecnico", defaultCanal);
            case "4" -> env.getProperty("canal.callback.ventas", defaultCanal);
            default -> defaultCanal;
        };
    }
}

