/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.campaign.data.WhatsAppApiResponse;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.documents.CampaignModel;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignModelUtil {
    private static final Logger log = LoggerFactory.getLogger(CampaignModelUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static CampaignModel buildFailedCampaignModel(String phoneNumber, WhatsAppTemplateRequest request, String canal, String messageError, String userName, String campaignHeaderId) {
        CampaignModel camp = new CampaignModel();
        camp.setConversationId(phoneNumber);
        camp.setMessageTemplate(request.getTemplate());
        camp.setCategoria(request.getCategoria());
        camp.setCanal(canal);
        camp.setSend(Boolean.valueOf(false));
        camp.setCampaignHeaderId(campaignHeaderId);
        camp.setUserName(userName);
        camp.setMessageId(UUID.randomUUID().toString());
        camp.setMessageError(messageError);
        camp.setMessageStatus("error");
        return camp;
    }

    public static String extractMessageId(String response) {
        try {
            WhatsAppApiResponse apiResponse = (WhatsAppApiResponse)mapper.readValue(response, WhatsAppApiResponse.class);
            return ((WhatsAppApiResponse.WAResponseMessage)apiResponse.getMessages().get(0)).getId();
        }
        catch (Exception ex) {
            log.error("Error parsing WhatsApp response", (Throwable)ex);
            return null;
        }
    }
}

