/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.CampaignDataDefaultRequest;
import com.whatsapp.campaign.data.CampaignDataRequest;
import com.whatsapp.campaign.data.ComponentWhatsapp;
import com.whatsapp.campaign.data.ConversationSummaryResponse;
import com.whatsapp.campaign.data.TemplateData;
import com.whatsapp.campaign.data.TemplateWhatsApp;
import com.whatsapp.campaign.data.WhatsAppCampaignModel;
import com.whatsapp.campaign.data.WhatsAppTemplate;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.HistoryConversationItem;
import com.whatsapp.campaign.documents.ImagenModel;
import com.whatsapp.campaign.exceptions.TemplateNotFoundException;
import com.whatsapp.campaign.repository.ImagenMessageRepository;
import com.whatsapp.campaign.repository.service.CampaignMessageDAO;
import com.whatsapp.campaign.service.HistoryConversationItemService;
import com.whatsapp.campaign.service.StateConversationService;
import com.whatsapp.campaign.service.TemplateService;
import com.whatsapp.campaign.service.sender.TemplateMessageSenderService;
import com.whatsapp.campaign.utils.CanalMapper;
import com.whatsapp.campaign.utils.PhoneNumberUtil;
import com.whatsapp.campaign.utils.StatusUtil;
import com.whatsapp.campaign.utils.TemplateBatchBuilder;
import com.whatsapp.campaign.utils.WhatsAppTemplateCarBuilderUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private final ApiWhatsAppService whatsAppService;
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationService;
    private final Environment env;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ObjectMapper objectMapper;
    private final ImagenMessageRepository imagenRepository;
    private final TemplateMessageSenderService templateMessageSenderService;
    ObjectMapper mapper = new ObjectMapper();

    public Mono<List<WhatsAppTemplate>> getTemplates() {
        log.info("FILTER ALL TEMPLATES");
        return this.whatsAppService.getTemplates().flatMap(data -> {
            try {
                ArrayList<WhatsAppTemplate> templates = new ArrayList<WhatsAppTemplate>();
                if (data == null || data.getData() == null) {
                    return Mono.just(templates);
                }
                for (TemplateData.Template templateNode : data.getData()) {
                    WhatsAppTemplate template = new WhatsAppTemplate();
                    template.setName(templateNode.getName());
                    template.setLanguage(templateNode.getLanguage());
                    template.setStatus(templateNode.getStatus());
                    template.setCategory(templateNode.getCategory());
                    template.setId(templateNode.getId());
                    ArrayList<WhatsAppTemplate.Component> components = new ArrayList<WhatsAppTemplate.Component>();
                    for (TemplateData.Component componentNode : templateNode.getComponents()) {
                        WhatsAppTemplate.Component component = new WhatsAppTemplate.Component();
                        component.setType(componentNode.getType());
                        component.setText(componentNode.getText());
                        component.setFormat(componentNode.getFormat());
                        components.add(component);
                    }
                    template.setComponents(components);
                    templates.add(template);
                }
                return Mono.just(templates);
            }
            catch (Exception e) {
                log.error("Error parsing templates", (Throwable)e);
                return Mono.error((Throwable)new RuntimeException("Error parsing templates"));
            }
        });
    }

    public Mono<WhatsAppTemplate> getTemplateById(String id) {
        Mono monoTemplate = this.getTemplates().flatMapMany(Flux::fromIterable).filter(template -> template.getId().equals(id)).next().switchIfEmpty(Mono.error((Throwable)new TemplateNotFoundException(id)));
        return monoTemplate.flatMap(tem -> this.obtenerIdImagen(tem.getId()).switchIfEmpty(Mono.just((Object)"S/N")).flatMap(imgUrl -> {
            if (imgUrl.equals("S/N")) {
                return Mono.just((Object)tem);
            }
            tem.setFileUrl(imgUrl);
            return Mono.just((Object)tem);
        }));
    }

    public Mono<Void> sendMessageFromTemplate(WhatsAppTemplateRequest request) {
        try {
            ArrayList<ComponentWhatsapp> components = new ArrayList<ComponentWhatsapp>();
            ComponentWhatsapp headerCompoent = request.generarHeaderComponent(request.getHeader());
            if (headerCompoent != null) {
                components.add(headerCompoent);
            }
            ComponentWhatsapp bodyComponent = request.generarBodyComponent(request.getBody());
            log.info("Body component: {}", (Object)bodyComponent);
            if (bodyComponent != null) {
                components.add(bodyComponent);
            }
            TemplateWhatsApp template = new TemplateWhatsApp(request.getTemplateName(), components, request.getLanguage());
            String phoneNumber = PhoneNumberUtil.validatePhoneNumber((String)request.getNumber());
            WhatsAppCampaignModel campaign = new WhatsAppCampaignModel(phoneNumber, template);
            String campaignJson = this.objectMapper.writeValueAsString((Object)campaign);
            log.info("Sending template message to numbers, {}", (Object)campaignJson);
            log.info("Sending template message to numbers");
            String canal_asesor = CanalMapper.getCanal((String)request.getCanal(), (Environment)this.env);
            HistoryConversationItem userHistoryConversation = new HistoryConversationItem(phoneNumber, "whatsapp", request.getTemplate(), StatusUtil.ST_ASESOR, "CAMPANA", "User");
            return this.whatsAppService.sendMessageTemplateToWhatsAppAPI((Object)campaign).flatMap(response -> {
                log.info("Response from WhatsApp API: {}", response);
                return this.stateConversationService.validateAndUpdateChatFromMetaTemplate(phoneNumber, canal_asesor, request.getTemplate(), request.getCategoria()).then(this.historyConversationService.save(userHistoryConversation)).doOnError(e -> log.error("ERROR AL CAMBIAR EL ESTADO", e));
            }).doOnError(e -> {
                Object messageError = "Error sending message to " + phoneNumber;
                log.error("Error sending message to " + phoneNumber + ": " + e.getMessage());
                if (e instanceof WebClientResponseException) {
                    WebClientResponseException webClientResponseException = (WebClientResponseException)e;
                    String errorBody = webClientResponseException.getResponseBodyAsString();
                    log.error("Error body from WhatsApp API: {}", (Object)errorBody);
                    messageError = errorBody;
                }
                CampaignModel camp = new CampaignModel();
                camp.setConversationId(phoneNumber);
                camp.setMessageTemplate(request.getTemplate());
                camp.setCategoria(request.getCategoria());
                camp.setCanal(canal_asesor);
                camp.setSend(Boolean.valueOf(false));
                camp.setMessageError((String)messageError);
                camp.setMessageStatus("error");
                this.campaignMessageDAO.save(camp).subscribe();
            });
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        return this.whatsAppService.getConversationSummary(fecha_inicio, fecha_fin);
    }

    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.campaignMessageDAO.getAllConversationIncident().map(campaignList -> {
            campaignList.forEach(campaign -> {
                String title = CanalMapper.getTitle((String)campaign.getCanal());
                if (title != null) {
                    campaign.setCanal(title);
                }
            });
            return campaignList;
        });
    }

    public Mono<ImagenModel> guardarUrlImagen(String id, String url) {
        ImagenModel imagen = new ImagenModel(id, url);
        return this.imagenRepository.save((Object)imagen);
    }

    public Mono<String> obtenerIdImagen(String id) {
        return this.imagenRepository.findByIdImagen(id).map(ImagenModel::getUrlImagen);
    }

    public Mono<Void> sendMessageFromTemplateCart(CampaignDataDefaultRequest request) {
        String userName = request.getUserName();
        List<WhatsAppTemplateRequest> listWhatsAppTemplateRequest = request.getListCamping().stream().map(WhatsAppTemplateCarBuilderUtil::buildCartTemplateDefault).toList();
        return this.templateMessageSenderService.sendMessageFromTemplateListItem(listWhatsAppTemplateRequest, userName);
    }

    public Mono<Void> sendTemplateBatch(CampaignDataRequest request) {
        String userName = request.getUserName();
        List listWhatsAppTemplateRequest = TemplateBatchBuilder.buildFromCampaignRequest((CampaignDataRequest)request);
        return this.templateMessageSenderService.sendMessageFromTemplateListItem(listWhatsAppTemplateRequest, userName);
    }

    public TemplateServiceImpl(ApiWhatsAppService whatsAppService, StateConversationService stateConversationService, HistoryConversationItemService historyConversationService, Environment env, CampaignMessageDAO campaignMessageDAO, ObjectMapper objectMapper, ImagenMessageRepository imagenRepository, TemplateMessageSenderService templateMessageSenderService, ObjectMapper mapper) {
        this.whatsAppService = whatsAppService;
        this.stateConversationService = stateConversationService;
        this.historyConversationService = historyConversationService;
        this.env = env;
        this.campaignMessageDAO = campaignMessageDAO;
        this.objectMapper = objectMapper;
        this.imagenRepository = imagenRepository;
        this.templateMessageSenderService = templateMessageSenderService;
        this.mapper = mapper;
    }
}

