/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.StateConversation;
import com.whatsapp.campaign.repository.service.CampaignMessageDAO;
import com.whatsapp.campaign.repository.service.ConversationDAO;
import com.whatsapp.campaign.service.StateConversationService;
import com.whatsapp.campaign.utils.StatusUtil;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StateConversationServiceImpl
implements StateConversationService {
    private static final Logger log = LoggerFactory.getLogger(StateConversationServiceImpl.class);
    private final ConversationDAO conversationDAO;
    private final CampaignMessageDAO campaignMessageDAO;

    public Mono<Void> validateAndUpdateChatFromMetaTemplate(String conversationId, String canalCallback, String campaignMessage, String categoria) {
        log.info("Validando y actualizando conversaci\u00f3n: {}, estado: {}, callback: {}", new Object[]{conversationId, StatusUtil.ST_CAMPANA, canalCallback});
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_CAMPANA, canalCallback).then(Mono.fromRunnable(() -> {
            CampaignModel camp = new CampaignModel();
            camp.setConversationId(conversationId);
            camp.setMessageTemplate(campaignMessage);
            camp.setCategoria(categoria);
            camp.setCanal(canalCallback);
            camp.setSend(Boolean.valueOf(true));
            this.campaignMessageDAO.save(camp).subscribe();
        }));
    }

    public Mono<Void> validateAndUpdateChat(String conversationId, String stateConversation, String callback) {
        log.info("VOLVIENDO A ESTADO: {} CONVERSACION ID: {}", (Object)stateConversation, (Object)conversationId);
        return this.conversationDAO.existsByConversationId(conversationId).flatMap(exists -> {
            log.warn("existe la conversacion: {}", exists);
            if (exists.booleanValue()) {
                return this.conversationDAO.findByConversationId(conversationId).flatMap(conversation -> {
                    conversation.setActive(Boolean.valueOf(true));
                    conversation.setStateConversation(stateConversation);
                    conversation.setUpdatedAt(LocalDateTime.now());
                    if (callback != null) {
                        conversation.setCallbackId(callback);
                    }
                    return this.conversationDAO.save(conversation).then();
                });
            }
            StateConversation newConversation = callback == null ? new StateConversation(conversationId, stateConversation) : new StateConversation(conversationId, stateConversation, callback);
            return this.conversationDAO.save(newConversation).then();
        });
    }

    public Mono<CampaignModel> validateAndUpdateChatFromMetaTemplateCart(String conversationId, String canalCallback, String campaignMessage, String category, String messageId, String userName, String campaignHeaderId) {
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_CAMPANA, canalCallback).then(Mono.defer(() -> {
            CampaignModel camp = new CampaignModel();
            camp.setConversationId(conversationId);
            camp.setMessageTemplate(campaignMessage);
            camp.setCategoria(category);
            camp.setCanal(canalCallback);
            camp.setSend(Boolean.valueOf(true));
            camp.setCampaignHeaderId(campaignHeaderId);
            camp.setUserName(userName);
            camp.setMessageId(messageId);
            camp.setMessageStatus("accepted");
            camp.setMessageError("");
            return this.campaignMessageDAO.save(camp);
        }));
    }

    public ConversationDAO getConversationDAO() {
        return this.conversationDAO;
    }

    public CampaignMessageDAO getCampaignMessageDAO() {
        return this.campaignMessageDAO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateConversationServiceImpl)) {
            return false;
        }
        StateConversationServiceImpl other = (StateConversationServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ConversationDAO this$conversationDAO = this.getConversationDAO();
        ConversationDAO other$conversationDAO = other.getConversationDAO();
        if (this$conversationDAO == null ? other$conversationDAO != null : !this$conversationDAO.equals(other$conversationDAO)) {
            return false;
        }
        CampaignMessageDAO this$campaignMessageDAO = this.getCampaignMessageDAO();
        CampaignMessageDAO other$campaignMessageDAO = other.getCampaignMessageDAO();
        return !(this$campaignMessageDAO == null ? other$campaignMessageDAO != null : !this$campaignMessageDAO.equals(other$campaignMessageDAO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateConversationServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationDAO $conversationDAO = this.getConversationDAO();
        result = result * 59 + ($conversationDAO == null ? 43 : $conversationDAO.hashCode());
        CampaignMessageDAO $campaignMessageDAO = this.getCampaignMessageDAO();
        result = result * 59 + ($campaignMessageDAO == null ? 43 : $campaignMessageDAO.hashCode());
        return result;
    }

    public String toString() {
        return "StateConversationServiceImpl(conversationDAO=" + this.getConversationDAO() + ", campaignMessageDAO=" + this.getCampaignMessageDAO() + ")";
    }

    public StateConversationServiceImpl(ConversationDAO conversationDAO, CampaignMessageDAO campaignMessageDAO) {
        this.conversationDAO = conversationDAO;
        this.campaignMessageDAO = campaignMessageDAO;
    }
}

