/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.data.HistoryConversationItemReq;
import com.whatsapp.campaign.data.HistoryConversationReq;
import com.whatsapp.campaign.data.PagedResponse;
import com.whatsapp.campaign.documents.HistoryConversation;
import com.whatsapp.campaign.documents.HistoryConversationItem;
import com.whatsapp.campaign.dto.HistoryConversationDTO;
import com.whatsapp.campaign.repository.HistoryConversationItemRepository;
import com.whatsapp.campaign.repository.HistoryConversationRepository;
import com.whatsapp.campaign.service.HistoryConversationService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class HistoryConversationServiceImpl
implements HistoryConversationService {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationServiceImpl.class);
    private final HistoryConversationRepository historyConversationRepository;
    private final HistoryConversationItemRepository historyConversationItemRepository;

    public Mono<Void> save(HistoryConversation historyConversation) {
        return this.historyConversationRepository.findByIdPlatform(historyConversation.getIdPlatform()).flatMap(existingConversation -> {
            if (historyConversation.getNick() != null && !historyConversation.getNick().equalsIgnoreCase("User")) {
                existingConversation.setNick(historyConversation.getNick());
            }
            if (historyConversation.getPlatform() == null) {
                existingConversation.setPlatform("whatsapp");
            } else {
                existingConversation.setPlatform(historyConversation.getPlatform());
            }
            existingConversation.setUpdatedAt(LocalDateTime.now());
            return this.historyConversationRepository.save(existingConversation);
        }).switchIfEmpty(this.historyConversationRepository.save((Object)historyConversation)).doOnSuccess(response -> log.info("HistoryConversation saved or updated: {}", response)).then().onErrorResume(error -> {
            log.error("Error saving or updating HistoryConversation: {}", (Object)error.getMessage());
            return Mono.empty();
        });
    }

    public Mono<PagedResponse<HistoryConversation>> getHistoryConversations(int page, int size, String sortDirection, String filterValue) {
        Sort sort = "desc".equalsIgnoreCase(sortDirection) ? Sort.by((String[])new String[]{"updatedAt"}).descending() : Sort.by((String[])new String[]{"updatedAt"}).ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        if (filterValue != null && !filterValue.isEmpty() && !filterValue.equalsIgnoreCase("undefined")) {
            return this.historyConversationRepository.findByIdPlatformRegex(filterValue, (Pageable)pageable).collectList().map(content -> new PagedResponse(content, page, size, (long)content.size(), 1, true));
        }
        return this.historyConversationRepository.count().flatMap(arg_0 -> this.lambda$getHistoryConversations$5(size, page, (Pageable)pageable, arg_0));
    }

    public Mono<Void> saveListConversation(List<HistoryConversationItem> historyConversationItem) {
        return this.historyConversationItemRepository.saveAll(historyConversationItem).then();
    }

    public Mono<Void> saveHistoryMigrate(HistoryConversationDTO historyConversation) {
        return this.save(this.entityConversationToResponse(historyConversation.getConversation())).then(this.saveListConversation(this.entityConversationListToResponse(historyConversation.getItems()))).onErrorResume(e -> {
            System.err.println("Error durante la migraci\u00f3n: " + e.getMessage());
            return Mono.empty();
        });
    }

    private List<HistoryConversationItem> entityConversationListToResponse(List<HistoryConversationItemReq> listHistoryItemReq) {
        return listHistoryItemReq.stream().map(arg_0 -> this.entityConversationItemToResponse(arg_0)).collect(Collectors.toList());
    }

    private HistoryConversationItem entityConversationItemToResponse(HistoryConversationItemReq historyItemReq) {
        String type = historyItemReq.getType() == null || historyItemReq.getType().isEmpty() ? "text" : historyItemReq.getType();
        return new HistoryConversationItem(historyItemReq.getIdPlatform(), historyItemReq.getPlatform(), historyItemReq.getMessage(), historyItemReq.getRol(), historyItemReq.getMessageTypeMode(), historyItemReq.getNick(), HistoryConversationServiceImpl.parseStringToLocalDateTime((String)historyItemReq.getCreatedAt()), type);
    }

    private HistoryConversation entityConversationToResponse(HistoryConversationReq historyReq) {
        return new HistoryConversation(historyReq.getIdPlatform(), historyReq.getNick(), historyReq.getPlatform());
    }

    public static LocalDateTime parseStringToLocalDateTime(String dateTimeString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        return LocalDateTime.parse(dateTimeString, formatter);
    }

    public Mono<String> getNickByIdPlatform(String idPlatform) {
        return this.historyConversationRepository.findByIdPlatform(idPlatform).map(HistoryConversation::getNick).defaultIfEmpty((Object)"User");
    }

    public HistoryConversationServiceImpl(HistoryConversationRepository historyConversationRepository, HistoryConversationItemRepository historyConversationItemRepository) {
        this.historyConversationRepository = historyConversationRepository;
        this.historyConversationItemRepository = historyConversationItemRepository;
    }

    private /* synthetic */ Mono lambda$getHistoryConversations$5(int size, int page, Pageable pageable, Long totalElements) {
        int totalPages = (int)Math.ceil((double)totalElements.longValue() / (double)size);
        boolean isLast = page + 1 >= totalPages;
        return this.historyConversationRepository.findAllBy(pageable).collectList().map(content -> new PagedResponse(content, page, size, totalElements.longValue(), totalPages, isLast));
    }
}

