/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.data.CampaignExportForm;
import com.whatsapp.campaign.data.CampaignSearchMessageRequest;
import com.whatsapp.campaign.data.CampaignSearchRequest;
import com.whatsapp.campaign.data.PagedResponse;
import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.documents.CampaignModelHeader;
import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.repository.service.CampaignMessageDAO;
import com.whatsapp.campaign.repository.service.CampaignModelHeaderDAO;
import com.whatsapp.campaign.service.CampaignService;
import com.whatsapp.campaign.utils.DepartmentUtil;
import com.whatsapp.campaign.utils.StatusLabelUtil;
import com.whatsapp.campaign.utils.Utils;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class CampaignServiceImpl
implements CampaignService {
    private static final Logger log = LoggerFactory.getLogger(CampaignServiceImpl.class);
    private final CampaignMessageDAO campaignMessageDAO;
    private final CampaignModelHeaderDAO campaignModelHeaderDAO;

    public Mono<List<DailyCountDTO>> obtenerListaDeCompanasPorFecha(LocalDate inicio, LocalDate fin) {
        return this.campaignMessageDAO.obtenerReporteDiario(inicio, fin).collectList().map(lista -> Utils.completarDiasFaltantes((List)lista, (LocalDate)inicio, (LocalDate)fin));
    }

    public Mono<PagedResponse<CampaignModel>> findByCampaignHeaderId(CampaignSearchMessageRequest request) {
        PageRequest pageable = PageRequest.of((int)request.getPage(), (int)request.getSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"}));
        Mono itemsMono = this.campaignMessageDAO.findByCampaignHeaderId(request.getCampaignHeaderId(), (Pageable)pageable).collectList();
        Mono totalMono = this.campaignMessageDAO.countByCampaignHeaderId(request.getCampaignHeaderId());
        return Mono.zip((Mono)itemsMono, (Mono)totalMono).map(tuple -> {
            List content = (List)tuple.getT1();
            long totalElements = (Long)tuple.getT2();
            int totalPages = (int)Math.ceil((double)totalElements / (double)request.getSize());
            boolean last = request.getPage() + 1 >= totalPages;
            return new PagedResponse(content, request.getPage(), request.getSize(), totalElements, totalPages, last);
        });
    }

    public Mono<PagedResponse<CampaignModelHeader>> getCampaignHeaders(CampaignSearchRequest request) {
        PageRequest pageable = PageRequest.of((int)request.getPage(), (int)request.getSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"}));
        Mono itemsMono = this.campaignModelHeaderDAO.findBetweenDatesCampaignHeader(request.getStartDate(), request.getEndDate(), (Pageable)pageable).collectList();
        Mono totalMono = this.campaignModelHeaderDAO.countByCreatedAtBetweenCampaignHeader(request.getStartDate(), request.getEndDate());
        return Mono.zip((Mono)itemsMono, (Mono)totalMono).map(tuple -> {
            List content = (List)tuple.getT1();
            long totalElements = (Long)tuple.getT2();
            int totalPages = (int)Math.ceil((double)totalElements / (double)request.getSize());
            boolean last = request.getPage() + 1 >= totalPages;
            return new PagedResponse(content, request.getPage(), request.getSize(), totalElements, totalPages, last);
        });
    }

    public Mono<Void> exportCampaigns(CampaignExportForm form, ServerHttpResponse response) {
        String campaignHeaderId = form.getCampaignHeaderId();
        response.getHeaders().setContentDisposition(ContentDisposition.attachment().filename("campaigns.csv").build());
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        String header = "Number,Name,Category,Canal,Status,Date,Observation\n";
        Flux csvContent = this.campaignMessageDAO.getCampaignsForExportByHeaderId(campaignHeaderId).map(campaign -> String.format("%s,%s,%s,%s,%s,%s,%s\n", campaign.getConversationId(), campaign.getUserName(), campaign.getCategoria(), DepartmentUtil.getDepartmentByCode((String)campaign.getCanal()), StatusLabelUtil.getStatusLabel((String)campaign.getMessageStatus()), StatusLabelUtil.formatLocalDateTimeEcuador((LocalDateTime)campaign.getCreatedAt()), StatusLabelUtil.resolveMessageError((String)campaign.getMessageError()))).startWith((Object[])new String[]{header}).map(line -> response.bufferFactory().wrap(line.getBytes(StandardCharsets.UTF_8)));
        return response.writeWith((Publisher)csvContent);
    }

    public CampaignServiceImpl(CampaignMessageDAO campaignMessageDAO, CampaignModelHeaderDAO campaignModelHeaderDAO) {
        this.campaignMessageDAO = campaignMessageDAO;
        this.campaignModelHeaderDAO = campaignModelHeaderDAO;
    }
}

