/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.repository.service;

import com.whatsapp.campaign.documents.CampaignModel;
import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.repository.CampaignMessageReposotory;
import com.whatsapp.campaign.repository.CampaignReactiveReportRepository;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class CampaignMessageDAO {
    private static final Logger log = LoggerFactory.getLogger(CampaignMessageDAO.class);
    private final CampaignMessageReposotory campaignMessageRepository;
    private final CampaignReactiveReportRepository campaignReactiveReportRepository;

    public Mono<CampaignModel> save(CampaignModel campaignModel) {
        return this.campaignMessageRepository.save((Object)campaignModel);
    }

    public Mono<String> findLastMessageTemplateByConversationId(String conversationId) {
        return this.campaignMessageRepository.findFirstByConversationIdOrderByCreatedAtDesc(conversationId).doOnNext(campaignModel -> log.info("CampaignModel encontrado: {}", campaignModel)).doOnSuccess(result -> log.info("Flujo completado con \u00e9xito: {}", result)).doOnError(error -> log.error("Error en el flujo: {}", (Object)error.getMessage())).map(CampaignModel::getMessageTemplate).defaultIfEmpty((Object)"");
    }

    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.campaignMessageRepository.findBySendFalse().collectList();
    }

    public Flux<DailyCountDTO> obtenerReporteDiario(LocalDate inicio, LocalDate fin) {
        return this.campaignReactiveReportRepository.getDailyCounts(inicio, fin);
    }

    public Mono<CampaignModel> findByMessageId(String messageId) {
        return this.campaignMessageRepository.findByMessageId(messageId);
    }

    public Flux<CampaignModel> findByCampaignHeaderId(String campaignHeaderId, Pageable pageable) {
        return this.campaignMessageRepository.findByCampaignHeaderId(campaignHeaderId, pageable);
    }

    public Mono<Long> countByCampaignHeaderId(String campaignHeaderId) {
        return this.campaignMessageRepository.countByCampaignHeaderId(campaignHeaderId);
    }

    public Flux<CampaignModel> getCampaignsForExportByHeaderId(String campaignHeaderId) {
        return this.campaignMessageRepository.getByCampaignHeaderId(campaignHeaderId);
    }

    public CampaignMessageDAO(CampaignMessageReposotory campaignMessageRepository, CampaignReactiveReportRepository campaignReactiveReportRepository) {
        this.campaignMessageRepository = campaignMessageRepository;
        this.campaignReactiveReportRepository = campaignReactiveReportRepository;
    }
}

