/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.documents;

import com.whatsapp.campaign.documents.HistoryConversationItem;
import com.whatsapp.campaign.utils.DateUtils;
import com.whatsapp.campaign.utils.StatusUtil;
import com.whatsapp.campaign.utils.TemplateTsaMessages;
import java.time.LocalDateTime;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/*
 * Exception performing whole class analysis ignored.
 */
@Document(collection="history_conversation_item")
public class HistoryConversationItem {
    @Id
    private String conversationId;
    private String idPlatform;
    private String platform;
    private String nick;
    private String message;
    private String type;
    private String rol;
    private String messageMetaId;
    private String messageTypeMode;
    private LocalDateTime createdAt;

    public HistoryConversationItem(String idPlatform, String platform, String message, String messageMetaId, String rol, String messageTypeMode, String nick) {
        this.idPlatform = idPlatform;
        this.platform = platform;
        this.message = message;
        this.type = "text";
        this.rol = rol;
        this.messageMetaId = messageMetaId;
        this.messageTypeMode = messageTypeMode;
        this.createdAt = LocalDateTime.now();
        this.nick = nick;
    }

    public HistoryConversationItem(String idPlatform, String platform, String message, String rol, String messageTypeMode, String nick, LocalDateTime createdAt) {
        this.idPlatform = idPlatform;
        this.platform = platform;
        this.message = message;
        this.rol = rol;
        this.messageTypeMode = messageTypeMode;
        this.nick = nick;
        this.createdAt = createdAt;
        this.type = "text";
    }

    public HistoryConversationItem(String idPlatform, String platform, String message, String rol, String messageTypeMode, String nick, LocalDateTime createdAt, String type) {
        this.idPlatform = idPlatform;
        this.platform = platform;
        this.message = message;
        this.rol = rol;
        this.messageTypeMode = messageTypeMode;
        this.nick = nick;
        this.createdAt = createdAt;
        this.type = type;
    }

    public HistoryConversationItem(String idPlatform, String platform, String message, String rol, String messageTypeMode, String nick) {
        this.idPlatform = idPlatform;
        this.platform = platform;
        this.message = message;
        this.type = "text";
        this.rol = rol;
        this.messageTypeMode = messageTypeMode;
        this.createdAt = LocalDateTime.now();
        this.nick = nick;
    }

    public static HistoryConversationItem saveConversationFromTsa(String conversationId, String message, String nick, String messageType) {
        return HistoryConversationItem.builder().idPlatform(conversationId).platform("whatsapp").message(HistoryConversationItem.formatMessageByType((String)message, (String)messageType)).type(messageType).rol(StatusUtil.ROL_THINKAGENT).messageTypeMode(StatusUtil.ROL_THINKAGENT).createdAt(LocalDateTime.now()).nick(nick == null ? "UNKNOWN" : nick).build();
    }

    public static HistoryConversationItem startConversation(String conversationId, String nick) {
        return new HistoryConversationItem(conversationId, "whatsapp", "EL CHAT FUE ACEPTADO", StatusUtil.ROL_SYSTEM, StatusUtil.ROL_SYSTEM, nick == null ? "UNKNOWN" : nick);
    }

    private static String formatMessageByType(String content, String type) {
        String stringDateFormatted = DateUtils.getDateStringDDMMYYYY_HHMMSS((LocalDateTime)LocalDateTime.now());
        switch (type) {
            case "text": {
                return content;
            }
            case "image": {
                return TemplateTsaMessages.TEMPLATE_MD_IMAGE.replace("{image_url}", content).replace("{date}", stringDateFormatted);
            }
            case "video": {
                return content;
            }
            case "document": {
                return content;
            }
            case "audio": {
                return content;
            }
        }
        return content;
    }

    public static HistoryConversationItemBuilder builder() {
        return new HistoryConversationItemBuilder();
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getIdPlatform() {
        return this.idPlatform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getNick() {
        return this.nick;
    }

    public String getMessage() {
        return this.message;
    }

    public String getType() {
        return this.type;
    }

    public String getRol() {
        return this.rol;
    }

    public String getMessageMetaId() {
        return this.messageMetaId;
    }

    public String getMessageTypeMode() {
        return this.messageTypeMode;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setIdPlatform(String idPlatform) {
        this.idPlatform = idPlatform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRol(String rol) {
        this.rol = rol;
    }

    public void setMessageMetaId(String messageMetaId) {
        this.messageMetaId = messageMetaId;
    }

    public void setMessageTypeMode(String messageTypeMode) {
        this.messageTypeMode = messageTypeMode;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryConversationItem)) {
            return false;
        }
        HistoryConversationItem other = (HistoryConversationItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$idPlatform = this.getIdPlatform();
        String other$idPlatform = other.getIdPlatform();
        if (this$idPlatform == null ? other$idPlatform != null : !this$idPlatform.equals(other$idPlatform)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$nick = this.getNick();
        String other$nick = other.getNick();
        if (this$nick == null ? other$nick != null : !this$nick.equals(other$nick)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$rol = this.getRol();
        String other$rol = other.getRol();
        if (this$rol == null ? other$rol != null : !this$rol.equals(other$rol)) {
            return false;
        }
        String this$messageMetaId = this.getMessageMetaId();
        String other$messageMetaId = other.getMessageMetaId();
        if (this$messageMetaId == null ? other$messageMetaId != null : !this$messageMetaId.equals(other$messageMetaId)) {
            return false;
        }
        String this$messageTypeMode = this.getMessageTypeMode();
        String other$messageTypeMode = other.getMessageTypeMode();
        if (this$messageTypeMode == null ? other$messageTypeMode != null : !this$messageTypeMode.equals(other$messageTypeMode)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryConversationItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $idPlatform = this.getIdPlatform();
        result = result * 59 + ($idPlatform == null ? 43 : $idPlatform.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $nick = this.getNick();
        result = result * 59 + ($nick == null ? 43 : $nick.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $rol = this.getRol();
        result = result * 59 + ($rol == null ? 43 : $rol.hashCode());
        String $messageMetaId = this.getMessageMetaId();
        result = result * 59 + ($messageMetaId == null ? 43 : $messageMetaId.hashCode());
        String $messageTypeMode = this.getMessageTypeMode();
        result = result * 59 + ($messageTypeMode == null ? 43 : $messageTypeMode.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "HistoryConversationItem(conversationId=" + this.getConversationId() + ", idPlatform=" + this.getIdPlatform() + ", platform=" + this.getPlatform() + ", nick=" + this.getNick() + ", message=" + this.getMessage() + ", type=" + this.getType() + ", rol=" + this.getRol() + ", messageMetaId=" + this.getMessageMetaId() + ", messageTypeMode=" + this.getMessageTypeMode() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public HistoryConversationItem(String conversationId, String idPlatform, String platform, String nick, String message, String type, String rol, String messageMetaId, String messageTypeMode, LocalDateTime createdAt) {
        this.conversationId = conversationId;
        this.idPlatform = idPlatform;
        this.platform = platform;
        this.nick = nick;
        this.message = message;
        this.type = type;
        this.rol = rol;
        this.messageMetaId = messageMetaId;
        this.messageTypeMode = messageTypeMode;
        this.createdAt = createdAt;
    }

    public HistoryConversationItem() {
    }
}

