/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.cache;

import java.util.List;
import java.util.Map;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MessageStateCacheService {
    private static final String REDIS_HASH_KEY = "states-messages-campaign:ids";
    private final ReactiveRedisTemplate<String, String> redisTemplate;

    public MessageStateCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Mono<Boolean> setState(String id, String state) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_HASH_KEY, (Object)id, (Object)state);
    }

    public Mono<String> getState(String id) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, (Object)id).map(Object::toString);
    }

    public Mono<Boolean> exists(String id) {
        return this.redisTemplate.opsForHash().hasKey((Object)REDIS_HASH_KEY, (Object)id);
    }

    public Flux<Map.Entry<String, String>> getStateBatch(List<String> ids) {
        return Flux.fromIterable(ids).flatMap(id -> this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, id).map(value -> Map.entry(id, value.toString())));
    }

    public Mono<Long> delete(String id) {
        return this.redisTemplate.opsForHash().remove((Object)REDIS_HASH_KEY, new Object[]{id});
    }
}

