/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StatusLabelUtil {
    private static final Map<String, String> STATUS_LABELS;

    public static String getStatusLabel(String status) {
        if (status == null) {
            return "Desconocido";
        }
        return STATUS_LABELS.getOrDefault(status.toLowerCase(), "Desconocido");
    }

    public static String resolveMessageError(String error) {
        return error == null || error.trim().isEmpty() ? "Campa\u00f1a aceptada" : error;
    }

    public static String formatLocalDateTimeEcuador(LocalDateTime localDateTime) {
        ZoneId zoneEcuador = ZoneId.of("America/Guayaquil");
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(zoneEcuador);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        return zonedDateTime.format(formatter);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accepted", "Aceptado");
        map.put("sent", "Enviado");
        map.put("delivered", "Entregado");
        map.put("read", "Le\u00eddo");
        map.put("failed", "Fallido");
        map.put("error", "Error");
        map.put("deleted", "Eliminado");
        STATUS_LABELS = Collections.unmodifiableMap(map);
    }
}

