/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.interceptors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.campaign.config.ApiResponse;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class CustomAuthenticationEntry
implements ServerAuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(CustomAuthenticationEntry.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException authException) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        log.warn("Fallo de autenticaci\u00f3n: {}", (Object)authException.getMessage());
        String mensaje = authException.getMessage() != null && authException.getMessage().toUpperCase().contains("JWT EXPIRED") ? "Token caducado" : "No autorizado.";
        ApiResponse apiResponse = ApiResponse.errorAuth((int)HttpStatus.UNAUTHORIZED.value(), (String)mensaje);
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes((Object)apiResponse);
            DataBuffer buffer = response.bufferFactory().wrap(bytes);
            return response.writeWith((Publisher)Mono.just((Object)buffer));
        }
        catch (JsonProcessingException e) {
            log.error("Error al serializar respuesta de autenticaci\u00f3n", (Throwable)e);
            response.setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            return response.setComplete();
        }
    }
}

