/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.campaign.data.WhatsAppApiResponse;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.entity.TCampaign;
import com.whatsapp.campaign.entity.TCampaignDetail;
import com.whatsapp.campaign.utils.StatusUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignModelUtil {
    private static final Logger log = LoggerFactory.getLogger(CampaignModelUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static TCampaignDetail buildFailedCampaignModelDetail(String conversationId, String messageTemplate, String messageError, Long campaignHeaderId) {
        TCampaignDetail campaignDetail = new TCampaignDetail();
        campaignDetail.setConversationId(conversationId);
        campaignDetail.setMessageTemplate(messageTemplate);
        campaignDetail.setDelivered(Boolean.valueOf(false));
        campaignDetail.setMessageId(UUID.randomUUID().toString());
        campaignDetail.setMessageError(messageError);
        campaignDetail.setMessageStatus(StatusUtil.ST_ERROR);
        campaignDetail.setCampaignId(campaignHeaderId);
        campaignDetail.setCreatedAt(LocalDateTime.now());
        return campaignDetail;
    }

    public static TCampaignDetail buildAceptedCampaignModelDetail(String conversationId, String messageTemplate, Long campaignHeaderId, String messageMetaId) {
        TCampaignDetail campaignDetail = new TCampaignDetail();
        campaignDetail.setConversationId(conversationId);
        campaignDetail.setMessageTemplate(messageTemplate);
        campaignDetail.setDelivered(Boolean.valueOf(false));
        campaignDetail.setMessageId(messageMetaId);
        campaignDetail.setMessageStatus(StatusUtil.ST_ACCEPTED);
        campaignDetail.setCampaignId(campaignHeaderId);
        campaignDetail.setCreatedAt(LocalDateTime.now());
        return campaignDetail;
    }

    public static TCampaign buildCampaignHeader(List<WhatsAppTemplateRequest> listRequest, String userName) {
        WhatsAppTemplateRequest first = listRequest.get(0);
        TCampaign campaign = new TCampaign();
        campaign.setTemplateName(first.getTemplateName());
        campaign.setCategoryName(first.getCategoria());
        campaign.setUserName(userName);
        campaign.setBatchSize(Integer.valueOf(listRequest.size()));
        campaign.setChannelName(first.getCanal());
        campaign.setChannelCode(first.getCanal());
        campaign.setPhoneId(Long.valueOf(1L));
        return campaign;
    }

    public static String extractMessageId(String response) {
        try {
            WhatsAppApiResponse apiResponse = (WhatsAppApiResponse)mapper.readValue(response, WhatsAppApiResponse.class);
            return ((WhatsAppApiResponse.WAResponseMessage)apiResponse.getMessages().get(0)).getId();
        }
        catch (Exception ex) {
            log.error("Error parsing WhatsApp response", (Throwable)ex);
            return null;
        }
    }
}

