/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.sender;

import com.whatsapp.campaign.cache.MessageStateCacheService;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.TemplateWhatsApp;
import com.whatsapp.campaign.data.WhatsAppCampaignModel;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.entity.TCampaign;
import com.whatsapp.campaign.entity.TCampaignDetail;
import com.whatsapp.campaign.exceptions.CustomException;
import com.whatsapp.campaign.repository.CampaignDetailRepository;
import com.whatsapp.campaign.service.BusinessPhoneService;
import com.whatsapp.campaign.service.CampaignService;
import com.whatsapp.campaign.utils.CampaignModelUtil;
import com.whatsapp.campaign.utils.ErrorParserUtil;
import com.whatsapp.campaign.utils.PhoneNumberUtil;
import com.whatsapp.campaign.utils.StatusUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TemplateMessageSenderService {
    private static final Logger log = LoggerFactory.getLogger(TemplateMessageSenderService.class);
    private final CampaignService campaignService;
    private final ApiWhatsAppService whatsAppService;
    private final MessageStateCacheService messageStateCacheService;
    private final CampaignDetailRepository campaignDetailRepository;
    private final BusinessPhoneService businessPhoneService;

    public Mono<String> sendMessageFromTemplateListItem(List<WhatsAppTemplateRequest> listRequest, String userName) {
        if (listRequest == null || listRequest.isEmpty()) {
            log.warn("La lista de plantillas est\u00e1 vac\u00eda, no se enviar\u00e1 ning\u00fan mensaje.");
            return Mono.error((Throwable)new CustomException("La lista de plantillas est\u00e1 vac\u00eda, no se enviar\u00e1 ning\u00fan mensaje.", HttpStatus.NOT_FOUND));
        }
        return this.businessPhoneService.findIdByPhoneId().doOnError(e -> log.error("Error al obtener el ID del tel\u00e9fono de WhatsApp: {}", (Object)e.getMessage(), e)).flatMap(phoneId -> {
            TCampaign campaignHeader = CampaignModelUtil.buildCampaignHeader((List)listRequest, (String)userName);
            return this.campaignService.saveCampaignHeader(campaignHeader).flatMap(header -> this.sendMessages(listRequest, userName, header.getId()));
        });
    }

    private Mono<String> sendMessages(List<WhatsAppTemplateRequest> listRequest, String userName, Long campaignId) {
        log.info("Iniciando env\u00edo de {} mensajes para la campa\u00f1a {} por el usuario {}", new Object[]{listRequest.size(), campaignId, userName});
        return Flux.fromIterable(listRequest).window(Duration.ofSeconds(5L)).flatMapSequential(batch -> batch.take(30L).flatMap(request -> this.sendMessageTemplateCartItem(request, userName, campaignId).flatMap(response -> {
            String messageId = response.getMessageId();
            String status = response.getMessageStatus() != null ? response.getMessageStatus() : StatusUtil.ST_UNKNOWN;
            log.info("Mensaje enviado exitosamente a {}. messageId: {}, status: {}", new Object[]{request.getNumber(), messageId, status});
            log.debug("Guardando estado del mensaje en cache. messageId: {}, status: {}", (Object)messageId, (Object)status);
            return this.messageStateCacheService.setState(messageId, status).then();
        }).onErrorResume(error -> {
            log.error("Error al enviar mensaje a {}: {}", new Object[]{request.getNumber(), error.getMessage(), error});
            return Mono.empty();
        }))).doOnError(error -> log.error("Error inesperado durante el env\u00edo masivo de mensajes: {}", (Object)error.getMessage(), error)).doOnTerminate(() -> log.info("Finaliz\u00f3 el env\u00edo de mensajes para la campa\u00f1a {}", (Object)campaignId)).then(Mono.just((Object)"Finaliz\u00f3 el env\u00edo de mensajes"));
    }

    private Mono<TCampaignDetail> sendMessageTemplateCartItem(WhatsAppTemplateRequest request, String userName, Long campaignHeaderId) {
        WhatsAppCampaignModel campaign = this.buildCampaign(request);
        String conversationId = campaign.getTo();
        return this.whatsAppService.sendMessageTemplate(campaign).flatMap(response -> {
            log.info("Response from WhatsApp API: {}", response);
            String messageId = CampaignModelUtil.extractMessageId((String)response);
            TCampaignDetail campaignSuccessDetail = CampaignModelUtil.buildAceptedCampaignModelDetail((String)conversationId, (String)request.getTemplate(), (Long)campaignHeaderId, (String)messageId);
            return this.campaignDetailRepository.save((Object)campaignSuccessDetail).doOnError(e -> log.error("ERROR AL CAMBIAR EL ESTADO", e));
        }).onErrorResume(e -> {
            String fullError = ErrorParserUtil.extractErrorMessage((Throwable)e);
            TCampaignDetail camapaignDetail = CampaignModelUtil.buildFailedCampaignModelDetail((String)conversationId, (String)request.getTemplate(), (String)fullError, (Long)campaignHeaderId);
            return this.campaignDetailRepository.save((Object)camapaignDetail);
        });
    }

    private WhatsAppCampaignModel buildCampaign(WhatsAppTemplateRequest request) {
        ArrayList components = new ArrayList();
        Optional.ofNullable(request.generarHeaderComponent(request.getHeader())).ifPresent(components::add);
        Optional.ofNullable(request.generarBodyComponent(request.getBody())).ifPresent(components::add);
        Optional.ofNullable(request.generarButtonComponents(request.getButtons())).filter(buttons -> !buttons.isEmpty()).ifPresent(components::addAll);
        TemplateWhatsApp template = new TemplateWhatsApp(request.getTemplateName(), components, request.getLanguage());
        String phoneNumber = PhoneNumberUtil.validatePhoneNumber((String)request.getNumber());
        return new WhatsAppCampaignModel(phoneNumber, template);
    }

    public TemplateMessageSenderService(CampaignService campaignService, ApiWhatsAppService whatsAppService, MessageStateCacheService messageStateCacheService, CampaignDetailRepository campaignDetailRepository, BusinessPhoneService businessPhoneService) {
        this.campaignService = campaignService;
        this.whatsAppService = whatsAppService;
        this.messageStateCacheService = messageStateCacheService;
        this.campaignDetailRepository = campaignDetailRepository;
        this.businessPhoneService = businessPhoneService;
    }
}

