/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.repository;

import com.whatsapp.campaign.dto.DailyCountDTO;
import com.whatsapp.campaign.dto.ErrorCampaignDetail;
import com.whatsapp.campaign.dto.ReportCampaignStatuses;
import com.whatsapp.campaign.dto.campaignDetail.CsvCampaignDetailDTO;
import com.whatsapp.campaign.entity.TCampaignDetail;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.r2dbc.repository.Query;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface CampaignDetailRepository
extends R2dbcRepository<TCampaignDetail, Long> {
    public Mono<TCampaignDetail> findByMessageId(String var1);

    public Flux<TCampaignDetail> findByCampaignId(Long var1, Pageable var2);

    public Mono<Long> countByCampaignId(Long var1);

    @Query(value="SELECT tc.conversation_id, tc.message_status, tc.created_at, tc.message_error FROM t_campaign_detail tc WHERE tc.campaign_id = :campaignHeaderId")
    public Flux<CsvCampaignDetailDTO> getByCampaignId(Long var1);

    @Query(value="SELECT TO_CHAR(created_at, 'YYYY-MM-DD') AS date, COUNT(*) AS total FROM t_campaign_detail WHERE created_at >= CAST(:initDate AS TIMESTAMP) AND created_at <= CAST(:endDate AS TIMESTAMP) GROUP BY TO_CHAR(created_at, 'YYYY-MM-DD') ORDER BY date ASC")
    public Flux<DailyCountDTO> getDailyCounts(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT message_status, COUNT(*) AS count FROM t_campaign_detail WHERE created_at >= :startDate AND created_at <= :endDate AND message_status IS NOT NULL GROUP BY message_status ORDER BY message_status")
    public Flux<ReportCampaignStatuses> getMessageStatusCounts(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT conversation_id, message_error, created_at, message_status FROM t_campaign_detail WHERE conversation_id IN (:conversationIds) AND message_status NOT IN ('read', 'delivered') ORDER BY conversation_id, created_at DESC LIMIT 1")
    public Flux<ErrorCampaignDetail> filterNumbersWithError(List<String> var1);
}

