/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.whatsapp.campaign.data.ComponentWhatsapp;
import com.whatsapp.campaign.data.ParameterWhatsApp;
import com.whatsapp.campaign.data.WhatsAppTemplateRequest;
import com.whatsapp.campaign.utils.Utils;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WhatsAppTemplateRequest {
    private String number;
    private String templateName;
    private String language;
    private Header header;
    private Body body;
    private String canal;
    private String template;
    private String categoria;
    private List<Button> buttons;

    public ComponentWhatsapp generarBodyComponent(Body body) {
        if (body == null || body.getType() == null || body.getParameters() == null || body.getParameters().isEmpty()) {
            return null;
        }
        ComponentWhatsapp component = new ComponentWhatsapp();
        component.setType(body.getType());
        List scapedParameters = body.getParameters().stream().map(param -> new BodyParameter(param.getType(), param.getParameter_name(), Utils.cleanString((String)param.getText()))).collect(Collectors.toList());
        for (BodyParameter parameter : scapedParameters) {
            if (parameter.getType() == null || !parameter.getType().equals("text")) continue;
            if (parameter.getText() == null) {
                return null;
            }
            ParameterWhatsApp parameterWhatsApp = new ParameterWhatsApp(parameter.getType(), parameter.getText(), parameter.getParameter_name());
            component.getParameters().add(parameterWhatsApp);
        }
        return component;
    }

    public ComponentWhatsapp generarHeaderComponent(Header header) {
        if (header == null || header.getType() == null || header.getParameters() == null || header.getParameters().isEmpty()) {
            return null;
        }
        ComponentWhatsapp component = new ComponentWhatsapp();
        component.setType(header.getType());
        for (Parameter parameter : header.getParameters()) {
            ParameterWhatsApp parameterWhatsApp;
            if (parameter.getType() != null && parameter.getType().equals("image")) {
                if (parameter.getImage() == null) {
                    return null;
                }
                parameterWhatsApp = new ParameterWhatsApp(parameter.getType(), (Object)parameter.getImage());
                component.getParameters().add(parameterWhatsApp);
            }
            if (parameter.getType() == null || !parameter.getType().equals("text")) continue;
            if (parameter.getText() == null) {
                return null;
            }
            parameterWhatsApp = new ParameterWhatsApp(parameter.getType(), (Object)parameter.getText());
            component.getParameters().add(parameterWhatsApp);
        }
        return component;
    }

    public List<ComponentWhatsapp> generarButtonComponents(List<Button> buttons) {
        if (buttons == null || buttons.isEmpty()) {
            return null;
        }
        return buttons.stream().map(button -> {
            ComponentWhatsapp component = new ComponentWhatsapp();
            component.setType("button");
            component.setSubType(button.getSub_type());
            component.setIndex(Integer.valueOf(button.getIndex()));
            for (ButtonParameter param : button.getParameters()) {
                if (!"text".equals(param.getType()) || param.getText() == null) continue;
                ParameterWhatsApp parameterWhatsApp = new ParameterWhatsApp(param.getType(), (Object)param.getText());
                component.getParameters().add(parameterWhatsApp);
            }
            return component;
        }).collect(Collectors.toList());
    }

    public String getNumber() {
        return this.number;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getLanguage() {
        return this.language;
    }

    public Header getHeader() {
        return this.header;
    }

    public Body getBody() {
        return this.body;
    }

    public String getCanal() {
        return this.canal;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getCategoria() {
        return this.categoria;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setCanal(String canal) {
        this.canal = canal;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setCategoria(String categoria) {
        this.categoria = categoria;
    }

    public void setButtons(List<Button> buttons) {
        this.buttons = buttons;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhatsAppTemplateRequest)) {
            return false;
        }
        WhatsAppTemplateRequest other = (WhatsAppTemplateRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$canal = this.getCanal();
        String other$canal = other.getCanal();
        if (this$canal == null ? other$canal != null : !this$canal.equals(other$canal)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$categoria = this.getCategoria();
        String other$categoria = other.getCategoria();
        if (this$categoria == null ? other$categoria != null : !this$categoria.equals(other$categoria)) {
            return false;
        }
        List this$buttons = this.getButtons();
        List other$buttons = other.getButtons();
        return !(this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhatsAppTemplateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $canal = this.getCanal();
        result = result * 59 + ($canal == null ? 43 : $canal.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $categoria = this.getCategoria();
        result = result * 59 + ($categoria == null ? 43 : $categoria.hashCode());
        List $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        return result;
    }

    public String toString() {
        return "WhatsAppTemplateRequest(number=" + this.getNumber() + ", templateName=" + this.getTemplateName() + ", language=" + this.getLanguage() + ", header=" + this.getHeader() + ", body=" + this.getBody() + ", canal=" + this.getCanal() + ", template=" + this.getTemplate() + ", categoria=" + this.getCategoria() + ", buttons=" + this.getButtons() + ")";
    }

    public WhatsAppTemplateRequest() {
    }

    public WhatsAppTemplateRequest(String number, String templateName, String language, Header header, Body body, String canal, String template, String categoria, List<Button> buttons) {
        this.number = number;
        this.templateName = templateName;
        this.language = language;
        this.header = header;
        this.body = body;
        this.canal = canal;
        this.template = template;
        this.categoria = categoria;
        this.buttons = buttons;
    }
}

