/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.config.ApiResponse;
import com.whatsapp.campaign.data.CampaignDataDefaultRequest;
import com.whatsapp.campaign.data.CampaignDataRequest;
import com.whatsapp.campaign.data.DateConversation;
import com.whatsapp.campaign.dto.image.ImagenModelDTO;
import com.whatsapp.campaign.dto.request.DateRequests;
import com.whatsapp.campaign.service.CampaignService;
import com.whatsapp.campaign.service.TemplateService;
import jakarta.validation.Valid;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api"})
public class WhatsappController {
    private static final Logger log = LoggerFactory.getLogger(WhatsappController.class);
    private final TemplateService templateService;
    private final CampaignService campaignService;

    @PostMapping(value={"/campaigns-count"})
    public Mono<ResponseEntity<?>> getAllCampaigns(@RequestBody DateRequests body) {
        LocalDate initDate = body.getStartDate();
        LocalDate endDate = body.getEndDate();
        return this.campaignService.obtenerListaDeCompanasPorFecha(initDate, endDate).flatMap(campaigns -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)campaigns))));
    }

    @GetMapping(value={"/templates"})
    @PreAuthorize(value="hasRole('CAMPANAS_META')")
    public Mono<ResponseEntity<?>> getTemplates() throws Exception {
        return this.templateService.getTemplates().flatMap(templates -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)templates))));
    }

    @GetMapping(value={"/templates/{id}"})
    @PreAuthorize(value="hasRole('CAMPANAS_META')")
    public Mono<ResponseEntity<?>> getTemplateById(@PathVariable(value="id", required=true) String id) {
        return this.templateService.getTemplateById(id).flatMap(template -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)template))));
    }

    @PostMapping(value={"/analytics-conversation"}, produces={"application/json"})
    public Mono<ResponseEntity<?>> getConversationSummary(@RequestBody DateConversation dateConversation) {
        return this.templateService.getConversationSummary(dateConversation.getFechaInicio(), dateConversation.getFechaFin()).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)response))));
    }

    @PostMapping(value={"/imagen-url"})
    @PreAuthorize(value="hasRole('ADMIN_CAMPANAS')")
    public Mono<ResponseEntity<?>> guardarImagen(@RequestBody ImagenModelDTO body) {
        return this.templateService.guardarUrlImagen(body.getIdImagen(), body.getUrlImagen()).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)response))));
    }

    @GetMapping(value={"/imagen-url/{id}"})
    @PreAuthorize(value="hasRole('CAMPANAS_META')")
    public Mono<ResponseEntity<?>> obtenerImagen(@PathVariable String id) {
        return this.templateService.obtenerIdImagen(id).flatMap(imageUrl -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)imageUrl))));
    }

    @PostMapping(value={"/send-template-cart"})
    @PreAuthorize(value="hasRole('CAMPANAS_COBRANZAS')")
    public Mono<ResponseEntity<?>> sendTemplateCart(@RequestBody CampaignDataDefaultRequest request) {
        return this.templateService.sendMessageFromTemplateCart(request).flatMap(messageResponse -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.okMessage((String)messageResponse))));
    }

    @PostMapping(value={"/send-template-batch"})
    @PreAuthorize(value="hasRole('CAMPANAS_COBRANZAS')")
    public Mono<ResponseEntity<?>> sendTemplateBatch(@RequestBody @Valid CampaignDataRequest request) {
        log.info("Received request to send template batch");
        return this.templateService.sendTemplateBatch(request).flatMap(messageResponse -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.okMessage((String)messageResponse))));
    }

    public WhatsappController(TemplateService templateService, CampaignService campaignService) {
        this.templateService = templateService;
        this.campaignService = campaignService;
    }
}

