/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.client.whatsapp;

import com.whatsapp.campaign.client.utils.WebClientUtils;
import com.whatsapp.campaign.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.campaign.data.ConversationAnalyticsResponse;
import com.whatsapp.campaign.data.ConversationSummary;
import com.whatsapp.campaign.data.ConversationSummaryResponse;
import com.whatsapp.campaign.data.TemplateData;
import com.whatsapp.campaign.data.WhatsAppCampaignModel;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiWhatsApp
implements ApiWhatsAppService {
    private static final Logger log = LoggerFactory.getLogger(ApiWhatsApp.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<TemplateData> getTemplates() {
        String WHATSAPP_API_TEMPLATE = this.env.getProperty("whatsapp.api.templates");
        String apiToken = this.env.getProperty("whatsapp.token");
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)this.webClient.build().get().uri(WHATSAPP_API_TEMPLATE, new Object[0]).header("Authorization", new String[]{"Bearer " + apiToken}), TemplateData.class, (String)"Get templates from whatsapp meta").flatMap(response -> Mono.just((Object)((TemplateData)response.getBody())));
    }

    public Mono<String> sendMessageTemplateToWhatsAppAPI(Object payload) {
        String apiToken = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        log.warn(payload.toString());
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)payload)), String.class, (String)"Send message template to WhatsApp API").flatMap(response -> Mono.just((Object)((String)response.getBody())));
    }

    public Mono<ConversationSummaryResponse> getConversationSummary(Date fecha_inicio, Date fecha_fin) {
        double MARKETING_COST = 0.1542;
        double UTILITY_COST = 0.0235;
        double SERVICE_COST = 0.0881;
        return this.getConversationAnalytics(fecha_inicio, fecha_fin).map(response -> {
            Map<String, Integer> conversationCounts = response.getConversationAnalytics().getData().stream().flatMap(data -> data.getDataPoints().stream()).collect(Collectors.groupingBy(ConversationAnalyticsResponse.DataPoint::getConversationCategory, Collectors.summingInt(ConversationAnalyticsResponse.DataPoint::getConversation)));
            List summaries = conversationCounts.entrySet().stream().map(entry -> {
                String category = (String)entry.getKey();
                int totalConversations = (Integer)entry.getValue();
                double costPerConversation = 0.0;
                switch (category.toUpperCase()) {
                    case "MARKETING": {
                        costPerConversation = MARKETING_COST;
                        break;
                    }
                    case "UTILITY": {
                        costPerConversation = UTILITY_COST;
                        break;
                    }
                    case "SERVICE": {
                        costPerConversation = SERVICE_COST;
                    }
                }
                double totalCost = (double)totalConversations * costPerConversation;
                return new ConversationSummary(category, totalConversations, totalCost);
            }).collect(Collectors.toList());
            double totalCost = summaries.stream().mapToDouble(ConversationSummary::getTotalCost).sum();
            totalCost = BigDecimal.valueOf(totalCost).setScale(2, RoundingMode.HALF_UP).doubleValue();
            return new ConversationSummaryResponse(summaries, totalCost);
        });
    }

    public Mono<ConversationAnalyticsResponse> getConversationAnalytics(Date fecha_inicio, Date fecha_fin) {
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.business.url");
        String TOKEN = this.env.getProperty("whatsapp.token");
        long fecha_inicio_tsp = fecha_inicio.getTime() / 1000L;
        long fecha_fin_tsp = fecha_fin.getTime() / 1000L;
        return this.webClient.build().get().uri(WHATSAPP_API_URL + "/?fields=conversation_analytics.start(" + fecha_inicio_tsp + ").end(" + fecha_fin_tsp + ").granularity(DAILY).dimensions(CONVERSATION_CATEGORY).conversation_types(REGULAR)", new Object[0]).header("Authorization", new String[]{"Bearer " + TOKEN}).retrieve().bodyToMono(ConversationAnalyticsResponse.class).doOnError(e -> log.error("Error downloading file", e)).onErrorResume(e -> Mono.empty());
    }

    public Mono<String> sendMessageTemplate(WhatsAppCampaignModel request) {
        String apiToken = this.env.getProperty("whatsapp.token");
        String WHATSAPP_API_URL = this.env.getProperty("whatsapp.api.readmessage.url");
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(WHATSAPP_API_URL, new Object[0])).header("Authorization", new String[]{"Bearer " + apiToken})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)request)), String.class, (String)"Send message template to WhatsApp API").flatMap(response -> Mono.just((Object)((String)response.getBody())));
    }

    public ApiWhatsApp(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

