/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.cache;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Service
public class MessageStateCacheService {
    private static final Logger log = LoggerFactory.getLogger(MessageStateCacheService.class);
    private static final String REDIS_HASH_KEY = "states-messages-campaign:ids";
    private final ReactiveRedisTemplate<String, String> redisTemplate;

    public MessageStateCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Mono<Boolean> setState(String id, String state) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_HASH_KEY, (Object)id, (Object)state).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).onErrorResume(e -> {
            log.error("Fallo al guardar el estado en Redis para ID {}: {}", new Object[]{id, e.getMessage(), e});
            return Mono.just((Object)false);
        });
    }

    public Mono<String> getState(String id) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, (Object)id).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).map(Object::toString).onErrorResume(e -> {
            log.error("Fallo al obtener el estado de Redis para ID {}: {}", new Object[]{id, e.getMessage(), e});
            return Mono.empty();
        });
    }

    public Mono<Boolean> exists(String id) {
        return this.redisTemplate.opsForHash().hasKey((Object)REDIS_HASH_KEY, (Object)id).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).onErrorResume(e -> {
            log.error("Fallo al verificar la existencia del ID {} en Redis: {}", new Object[]{id, e.getMessage(), e});
            return Mono.just((Object)false);
        });
    }

    public Flux<Map.Entry<String, String>> getStateBatch(List<String> ids) {
        return Flux.fromIterable(ids).flatMap(id -> this.redisTemplate.opsForHash().get((Object)REDIS_HASH_KEY, id).timeout(Duration.ofSeconds(5L)).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofMillis(200L))).map(value -> Map.entry(id, value.toString()))).onErrorResume(e -> {
            log.error("Fallo al obtener el batch de estados en Redis: {}", (Object)e.getMessage(), e);
            return Flux.empty();
        });
    }

    public Mono<Long> delete(String id) {
        return this.redisTemplate.opsForHash().remove((Object)REDIS_HASH_KEY, new Object[]{id});
    }
}

