/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.tsa.agent.models.AgentModel;
import com.agent.client.tsa.conversation.models.AssignConversationDTO;
import com.agent.client.tsa.conversation.service.TsaConversationApiService.TsaConversationApiService;
import com.agent.tsa.service.AgentService;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.service.RoundRobinAssignmentService;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RoundRobinAssignmentServiceImpl
implements RoundRobinAssignmentService {
    private static final Logger log = LoggerFactory.getLogger(RoundRobinAssignmentServiceImpl.class);
    private final TsaConversationApiService tsaConversationApiService;
    private final ConversationService conversationService;
    private final AgentService agentService;

    private Mono<String> processConversationsWithAgents(List<AgentModel> agents, String accountId) {
        AtomicInteger agentPivot = new AtomicInteger(0);
        AtomicInteger cycleCounter = new AtomicInteger(0);
        int maxCycles = 10;
        return this.conversationService.getConversationsNotAssigned(accountId).expand(conversations -> {
            if (conversations == null || conversations.isEmpty() || cycleCounter.incrementAndGet() > maxCycles) {
                return Mono.empty();
            }
            log.info("realizando ciclo {}", (Object)cycleCounter.get());
            return Mono.delay((Duration)Duration.ofSeconds(15L)).flatMap(i -> this.conversationService.getConversationsNotAssigned(accountId));
        }).takeWhile(conversations -> conversations != null && !conversations.isEmpty()).flatMapIterable(list -> list).flatMap(conv -> {
            if (conv.getMeta() == null || conv.getMeta().getTeam() == null) {
                return Mono.empty();
            }
            int idx = agentPivot.getAndUpdate(i -> (i + 1) % agents.size());
            String agentId = ((AgentModel)agents.get(idx)).getId();
            String teamId = String.valueOf(conv.getMeta().getTeam().getId());
            AssignConversationDTO assigmentDTO = AssignConversationDTO.builder().assigneeId(agentId).teamId(teamId).build();
            return this.tsaConversationApiService.assignConversation(conv.getId(), accountId, assigmentDTO).doOnSuccess(v -> log.info("Conversation {} assigned to agent {}", (Object)conv.getId(), (Object)agentId)).onErrorResume(e -> {
                log.error("Error assigning conversation {} to agent {}: {}", new Object[]{conv.getId(), agentId, e.getMessage()});
                return Mono.empty();
            });
        }, 2).then(Mono.just((Object)"All conversations assigned or none found"));
    }

    public Mono<String> assignConversations(String accountId) {
        Mono activeAgents = this.agentService.getActiveAgents(accountId).flatMap(agentList -> {
            log.info("Active agents: {}", agentList);
            if (agentList.isEmpty()) {
                return Mono.empty();
            }
            return Mono.just((Object)agentList);
        });
        return activeAgents.flatMap(agents -> this.processConversationsWithAgents(agents, accountId));
    }

    public RoundRobinAssignmentServiceImpl(TsaConversationApiService tsaConversationApiService, ConversationService conversationService, AgentService agentService) {
        this.tsaConversationApiService = tsaConversationApiService;
        this.conversationService = conversationService;
        this.agentService = agentService;
    }
}

