/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.client.external.service.SendMessagesToApiService;
import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.exceptions.CustomException;
import com.agent.tsa.data.RequestMessageModel;
import com.agent.tsa.data.conversation.Conversation;
import com.agent.tsa.data.conversation.Meta;
import com.agent.tsa.data.conversation.messages.Attachment;
import com.agent.tsa.data.conversation.messages.CallbackTsaMessage;
import com.agent.tsa.data.conversation.messages.MessageDetails;
import com.agent.tsa.data.sender.Sender;
import com.agent.tsa.entity.TConversation;
import com.agent.tsa.events.MessageEvent;
import com.agent.tsa.events.ResponseMessageEvent;
import com.agent.tsa.models.conversation.CreateConversationModel;
import com.agent.tsa.models.conversation.TextMessage;
import com.agent.tsa.service.AgentService;
import com.agent.tsa.service.ContactService;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.service.FileService;
import com.agent.tsa.service.MessageService;
import com.agent.tsa.service.TeamService;
import com.agent.tsa.utils.StatusUtil;
import com.agent.tsa.utils.TemplateMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    private final TeamService teamService;
    private final ConversationService conversationService;
    private final SendMessagesToApiService sendMessagesToApiService;
    private final TsaMessageService tsaMessageService;
    private final ContactService contactService;
    private final FileService fileService;
    private final Environment env;
    private AgentService agentService;

    public Mono<ResponseMessageEvent> processRequestToSendMessage(RequestMessageModel request, String callback, String source) {
        log.warn("SOURCE {} CALLBACK {}", (Object)source, (Object)callback);
        return this.teamService.findAccountIdByCallbackId(callback).flatMap(accountId -> {
            log.info("ACCOUNT ID {}", accountId);
            return this.conversationService.findConversationByIdentifier(request.getId(), accountId).defaultIfEmpty((Object)new TConversation()).flatMap(conv -> {
                if (conv.getId() == null) {
                    return this.generateNewConversationAndSendMessage(request, callback, accountId).thenReturn((Object)ResponseMessageEvent.builder().eventType("new_conversation_opened").build());
                }
                log.info("EXISTING CONVERSATION {}", conv);
                return this.switchMessage(request, conv, source).flatMap(resp -> {
                    log.info("RESPONSE MENSAJES {}", resp);
                    return Mono.just((Object)ResponseMessageEvent.builder().eventType("message_new_delivered").callbackTsaMessage(resp).build());
                });
            });
        });
    }

    private Mono<CallbackTsaMessage> switchMessage(RequestMessageModel request, TConversation conversation, String source) {
        if (request.getPayload() == null) {
            return Mono.error((Throwable)new CustomException("La estructura de la solicitud no es correcta.", HttpStatus.BAD_REQUEST));
        }
        String messageType = request.getPayload().getType();
        boolean hasRepliedMessage = request.getPayload().getRepliedMessage() != null;
        String newMessage = hasRepliedMessage ? TemplateMessage.messageBuilded((String)request.getPayload().getRepliedMessage(), (String)request.getPayload().getContent()) : request.getPayload().getContent();
        switch (messageType) {
            case "text": {
                TextMessage textMessage = new TextMessage();
                textMessage.setMessageType("incoming");
                textMessage.setContent(newMessage);
                textMessage.setPrivate(false);
                textMessage.setContentType(messageType);
                return this.sendMessage(textMessage, conversation.getConversationId(), conversation.getAccountId());
            }
            case "file": {
                String caption = hasRepliedMessage ? TemplateMessage.messageBuilded((String)request.getPayload().getRepliedMessage(), (String)"") : null;
                log.info("Caption file {}", (Object)caption);
                String token = this.getTokenBySourceMessage(source);
                return this.fileService.downloadFilesFromMeta(request.getPayload().getContent(), "", token).flatMap(fileDownloadMeta -> this.tsaMessageService.sendMultipartMessageToTSA(fileDownloadMeta, String.valueOf(conversation.getConversationId()), caption, conversation.getAccountId()));
            }
        }
        return Mono.error((Throwable)new CustomException("El tipo de mensaje no es correcto.", HttpStatus.BAD_REQUEST));
    }

    private String getTokenBySourceMessage(String source) {
        if (source == null || source.isEmpty()) {
            log.warn("SOURCE IS NULL OR EMPTY, USING DEFAULT TOKEN");
            return null;
        }
        switch (source.toLowerCase()) {
            case "marci-whatsapp": {
                return this.env.getProperty("marci.whatsapp.token");
            }
            case "mtpwr-whatsapp": {
                return this.env.getProperty("whatsapp.token");
            }
            case "tws-whatsapp": {
                return this.env.getProperty("tws.pruebas.whatsapp.token");
            }
        }
        return this.env.getProperty(source);
    }

    private Mono<Void> generateNewConversationAndSendMessage(RequestMessageModel request, String callbackId, String accountId) {
        log.info("NEW CONVERSATION FOR CALLBACK {}", (Object)callbackId);
        return this.contactService.findIdTsaByIdentifier(request.getNick(), request.getId(), request.getChannel(), accountId).flatMap(contactId -> this.teamService.findTeamIdByCallback(callbackId).flatMap(teamId -> this.teamService.findInboxIdByCallback(callbackId).flatMap(inboxId -> {
            log.info("CALLBACK {}, TEAM ALLOWED {}, INBOX ALLOWED {}", new Object[]{callbackId, teamId, inboxId});
            return this.validateActiveAgentAndOpenConversation(request, accountId, teamId, inboxId, contactId, callbackId);
        })));
    }

    private Mono<Void> validateActiveAgentAndOpenConversation(RequestMessageModel request, String accountId, Long teamId, String inboxId, Long contactId, String callback) {
        String identifier = request.getId();
        return this.agentService.obtenerAgenteDesdeCampana(identifier, callback, accountId).flatMap(agentIdFromCampaign -> {
            if (agentIdFromCampaign != 0L) {
                log.info("AGENTE DESDE CAMPA\u00d1A ASIGNADO: {}", agentIdFromCampaign);
                return Mono.just((Object)agentIdFromCampaign);
            }
            log.info("No se obtuvo agente desde campa\u00f1a. Intentando con \u00faltimo asignado...");
            return this.conversationService.getLastAssignedIdFromConversationByContactIdAndTeamId(accountId, contactId, teamId).defaultIfEmpty((Object)0L).flatMap(lastAgentId -> {
                if (lastAgentId != 0L) {
                    return this.agentService.isLastAgentActive(accountId, lastAgentId).map(isActive -> isActive != false ? lastAgentId : 0L);
                }
                return Mono.just((Object)0L);
            });
        }).flatMap(finalAgentId -> {
            CreateConversationModel convMessageModel = new CreateConversationModel(inboxId, contactId, StatusUtil.ST_CONVERSATION_OPEN, teamId, request.getPayload().getContent(), request.getCallbackUrl(), null, request.getIgnoreInitMessage());
            if (finalAgentId != 0L) {
                convMessageModel.setAssigneeId(String.valueOf(finalAgentId));
                log.info("AGENTE FINAL ASIGNADO: {}", finalAgentId);
            }
            if (request.getPayload().getRepliedMessage() != null) {
                String newMessage = TemplateMessage.messageBuilded((String)request.getPayload().getRepliedMessage(), (String)request.getPayload().getContent());
                convMessageModel.getMessage().setContent(newMessage);
            }
            return this.conversationService.openNewConversation(convMessageModel, accountId);
        });
    }

    public Mono<CallbackTsaMessage> sendMessage(TextMessage textMessage, Long conversationId, String accountId) {
        return this.tsaMessageService.sendMesssageToTSA(textMessage, String.valueOf(conversationId), accountId);
    }

    public Mono<ResponseEntity<String>> sendMessagesToAPI(MessageEvent callback) {
        boolean isCloseCovensationEvent;
        Conversation conversation = callback.getConversation();
        String statusConversation = conversation.getStatus();
        String eventContentType = callback.getContentType() != null ? callback.getContentType() : "";
        String eventContent = callback.getContent() != null ? callback.getContent() : "";
        boolean bl = isCloseCovensationEvent = eventContentType.equalsIgnoreCase("input_csat") && eventContent.toUpperCase().startsWith("POR FAVOR CALIFICA ESTA CONVERSACI");
        if (!isCloseCovensationEvent && statusConversation.equals(StatusUtil.ST_CONVERSATION_RESOLVED)) {
            log.error("CONVERSATION RESOLVED");
            if (callback.getEvent().equalsIgnoreCase("message_updated")) {
                log.info("MESSAGE UPDATED AND CONVERSATION RESOLVED WAS IGNORED");
                return Mono.empty();
            }
            TextMessage message = new TextMessage(StatusUtil.MSG_CONVERSACION_CERRADA, "outgoing", true, "text");
            return this.tsaMessageService.sendMesssageToTSA(message, String.valueOf(conversation.getId()), String.valueOf(callback.getAccount().getId())).thenReturn((Object)ResponseEntity.badRequest().body((Object)"CONVERSATION CLOSED"));
        }
        if (isCloseCovensationEvent) {
            log.info("SENDING END CONVERSATION MESSAGE");
        }
        if (conversation.getMeta().getTeam() == null) {
            return Mono.just((Object)ResponseEntity.badRequest().body((Object)"{\"error\": \"msg\"}"));
        }
        Long teamId = conversation.getMeta().getTeam().getId();
        String callbackUrlFromConversation = conversation.getAdditionalAttributes() == null ? null : conversation.getAdditionalAttributes().getCallbackUrl();
        Mono findCallbackUrl = callbackUrlFromConversation != null ? Mono.just((Object)callbackUrlFromConversation) : this.teamService.findAccountIdByTeamId(teamId).flatMap(accountId -> {
            log.info("TEAM ID {} ACCOUNT ID {}", (Object)teamId, accountId);
            return this.conversationService.findCallbackUrlFromConversationIdAndAccountId(String.valueOf(conversation.getId()), accountId);
        });
        return findCallbackUrl.flatMap(callbackUrl -> {
            log.info("CALLBACK URL {}", callbackUrl);
            String messageType = callback.getMessageType();
            String eventMessage = callback.getEvent();
            if (messageType.equalsIgnoreCase("incoming") || messageType.equals("template") && eventMessage.equals("message_updated")) {
                return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
            }
            if (eventMessage.equals("message_updated") && callback.getContent() != null && callback.getContent().toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                log.info("MENSAJE ELIMINADO IGNORADO {}", (Object)callback.getContent());
                return Mono.just((Object)ResponseEntity.badRequest().body((Object)"MENSAJE NO ELIMINADO EN EL CLIENTE"));
            }
            if (messageType.equals("template")) {
                String templateContentType = callback.getContentType();
                String content = callback.getContent();
                if (templateContentType.equalsIgnoreCase("text")) {
                    Sender sender = conversation.getMeta().getSender();
                    if (sender.getIdentifier() == null) {
                        log.error("Identifier is null");
                        return Mono.just((Object)ResponseEntity.badRequest().body((Object)"EL NUMERO DE TELEFONO NO EXISTE"));
                    }
                    String identifierClient = sender.getIdentifier();
                    String nickName = sender.getName();
                    RequestMessageModel messageModel = RequestMessageModel.createTextMessage((String)identifierClient, (String)"message", (String)"text", (String)content, (String)nickName);
                    return this.sendMessagesToApiService.sendMessageToWebhook(messageModel, callbackUrl).flatMap(ignore -> Mono.just((Object)ResponseEntity.ok((Object)"TEMPLATE MESSAGE SENT")));
                }
            }
            List messages = conversation.getMessages();
            Meta meta = conversation.getMeta();
            if (messages != null && !messages.isEmpty()) {
                for (MessageDetails msg : messages) {
                    Long inReplyMessageid = callback.getContentAttributes() != null ? callback.getContentAttributes().getInReplyTo() : null;
                    Sender sender = meta.getSender();
                    String userIdentifier = sender.getIdentifier();
                    String nickName = sender.getName();
                    Long idTsaMessage = msg.getId();
                    if (userIdentifier == null) {
                        log.error("Identifier is null");
                        return Mono.just((Object)ResponseEntity.badRequest().body((Object)"EL IDENTIFIADOR DEL USUARIO NO EXISTE"));
                    }
                    String contentType = msg.getContentType();
                    String content = msg.getContent();
                    List attachments = msg.getAttachments();
                    if (!contentType.equalsIgnoreCase("text") && !contentType.equalsIgnoreCase("input_csat")) continue;
                    if (content != null) {
                        RequestMessageModel messageModel = RequestMessageModel.createTemplateMessage((String)userIdentifier, (Long)idTsaMessage, (Long)inReplyMessageid, (String)"message", (String)"text", (String)content, (String)nickName);
                        return this.sendMessagesToApiService.sendMessageToWebhook(messageModel, callbackUrl).flatMap(ignore -> this.sendAttachments(userIdentifier, inReplyMessageid, attachments, callbackUrl, nickName).then(Mono.just((Object)ResponseEntity.ok().build())));
                    }
                    return this.sendAttachments(userIdentifier, inReplyMessageid, attachments, callbackUrl, nickName).then(Mono.just((Object)ResponseEntity.ok().build()));
                }
            }
            log.error("NO MESSAGES TO SEND");
            return Mono.empty();
        });
    }

    public Mono<Void> sendPrivateNotFoundTeamMessage(String inboxId, String conversationId) {
        TextMessage TextMessage2 = new TextMessage("Este mensaje no pudo ser enviado, por favor asignarle un equipo antes de reintentarlo", "outgoing", true, "text");
        return this.teamService.findAccountIdByInboxId(String.valueOf(inboxId)).flatMap(accountId -> this.tsaMessageService.sendMesssageToTSA(TextMessage2, conversationId, accountId).then());
    }

    public Mono<String> sendAttachments(String userIdentifier, Long inReplyMessageid, List<Attachment> attachments, String callbackUrl, String nickName) {
        if (attachments != null && !attachments.isEmpty()) {
            return Flux.fromIterable(attachments).flatMap(att -> {
                Long idTsaMessage = att.getMessageId();
                if (att.getFileType().equals("file")) {
                    att.setFileType("document");
                } else {
                    att.setFileType(att.getFileType());
                }
                if (att.getFileType().equals("audio")) {
                    return this.fileService.convertAudioFromUrl(att.getDataUrl()).flatMap(audioUrl -> {
                        String templateUrl = this.env.getProperty("client.download.files").replace("{file_id}", (CharSequence)audioUrl);
                        RequestMessageModel messageModel = RequestMessageModel.createTemplateMessage((String)userIdentifier, (Long)idTsaMessage, (Long)inReplyMessageid, (String)"message", (String)"audio", (String)templateUrl, (String)nickName);
                        log.info("AUDIO URL {}", (Object)templateUrl);
                        return this.sendMessagesToApiService.sendMessageToWebhook(messageModel, callbackUrl).doOnSuccess(ignore -> log.info("Attachment sent")).doOnError(error -> log.error("Failed to send attachment for URL: {}. Error: {}", (Object)att.getDataUrl(), (Object)error.getMessage()));
                    });
                }
                RequestMessageModel messageModel = RequestMessageModel.createTemplateMessage((String)userIdentifier, (Long)idTsaMessage, (Long)inReplyMessageid, (String)"message", (String)att.getFileType(), (String)att.getDataUrl(), (String)nickName);
                return this.sendMessagesToApiService.sendMessageToWebhook(messageModel, callbackUrl).doOnSuccess(ignore -> log.info("Attachment sent")).doOnError(error -> log.error("Failed to send attachment for URL: {}. Error: {}", (Object)att.getDataUrl(), (Object)error.getMessage()));
            }).then(Mono.just((Object)"TODOS LOS ARCHIVOS PROCESADOS"));
        }
        return Mono.just((Object)"NO EXISTEN DOCUMENTOS PARA ENVIAR");
    }

    public MessageServiceImpl(TeamService teamService, ConversationService conversationService, SendMessagesToApiService sendMessagesToApiService, TsaMessageService tsaMessageService, ContactService contactService, FileService fileService, Environment env, AgentService agentService) {
        this.teamService = teamService;
        this.conversationService = conversationService;
        this.sendMessagesToApiService = sendMessagesToApiService;
        this.tsaMessageService = tsaMessageService;
        this.contactService = contactService;
        this.fileService = fileService;
        this.env = env;
        this.agentService = agentService;
    }
}

