/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.auto.RedissonConversationLockService;
import com.agent.cache.ConversationCacheService;
import com.agent.client.tsa.contact.service.TsaContactApiService;
import com.agent.client.tsa.conversation.models.ConversationsNotAssigned.ConvMetaNotAssigned;
import com.agent.client.tsa.conversation.models.ConversationsNotAssigned.ConversationPayload;
import com.agent.client.tsa.conversation.service.TsaConversationApiService.TsaConversationApiService;
import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.tsa.data.conversation.Meta;
import com.agent.tsa.data.sender.Sender;
import com.agent.tsa.data.team.Team;
import com.agent.tsa.entity.TContact;
import com.agent.tsa.entity.TConversation;
import com.agent.tsa.enums.ConversationStateEnum;
import com.agent.tsa.events.ConversationEvent;
import com.agent.tsa.models.conversation.CreateConversationModel;
import com.agent.tsa.models.conversation.TextMessage;
import com.agent.tsa.repository.ConversationDAO;
import com.agent.tsa.service.ContactService;
import com.agent.tsa.service.ConversationService;
import com.agent.tsa.service.TeamService;
import com.agent.tsa.utils.StatusUtil;
import com.agent.utils.FechaUtils;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ConversationServiceImpl
implements ConversationService {
    private static final Logger log = LoggerFactory.getLogger(ConversationServiceImpl.class);
    private final ConversationCacheService conversationCacheService;
    private final TeamService teamService;
    private final ConversationDAO conversationDAO;
    private final TsaContactApiService tsaContactApiService;
    private final TsaConversationApiService tsaConversationApiService;
    private final ContactService contactService;
    private final TsaMessageService tsaMessageService;
    private final RedissonConversationLockService redissonConversationLockService;
    private final Environment env;

    public Mono<Long> getLastAssignedIdFromConversationByContactIdAndTeamId(String accointId, Long contactId, Long TeamId) {
        return this.conversationDAO.getLastAssignedIdFromConversationByContactIdAndTeamId(accointId, contactId, TeamId);
    }

    private Mono<TConversation> saveOrUpdate(TConversation conversation, List<String> labels) {
        return this.redissonConversationLockService.processEventWithLock(conversation, labels);
    }

    public Mono<TConversation> saveOrUpdateConversation(ConversationEvent convEvent, String event) {
        Long contactId = convEvent.getContactInbox().getContactId();
        Long conversationId = convEvent.getId();
        List labels = convEvent.getLabels() != null ? convEvent.getLabels() : List.of();
        Long teamId = convEvent.getMeta().getTeam().getId();
        if (!convEvent.hasStateChanged() && !convEvent.validateConversationTaggedByMetaAndNeedsContinue(this.env.getProperty("label.caducado"))) {
            log.warn("ACTUALIZACION DE LA CONVERSACION IGNORADA");
            return this.validarConversacionCerradaGuardarEtiqueta(conversationId, teamId, labels);
        }
        log.info("continuando el proceso");
        String callbackUrlFromEvent = convEvent.getAdditionalAttributes() != null ? convEvent.getAdditionalAttributes().getCallbackUrl() : null;
        log.warn("CONTACT TSA ID: {}", (Object)contactId);
        return this.teamService.findAccountIdByTeamId(teamId).flatMap(accountId -> {
            log.info("finding account id by teamid, teamid {}, account allowed {}", (Object)teamId, accountId);
            Mono filterConversation = this.filterConversationsAndValidate(conversationId, accountId, convEvent.getStatus());
            Mono getCallbackUrl = this.teamService.findCallbackUrlFromTeamIdAndAccountId(String.valueOf(teamId), accountId);
            return filterConversation.flatMap(statusConversationMeta -> {
                log.info("STATUS CONVERSATION META {}", statusConversationMeta);
                if (statusConversationMeta.equals(ConversationStateEnum.INVALID.getState())) {
                    log.info("CONVERSATION IS RESOLVED OR INVALID {}", (Object)conversationId);
                    return Mono.empty();
                }
                return getCallbackUrl.flatMap(callbackUrlFromDb -> {
                    log.info("ACCOUNT ID {}", accountId);
                    return this.validateIfContactExists(contactId, accountId).flatMap(contactIdSaved -> {
                        String callbackUrl = callbackUrlFromEvent == null ? callbackUrlFromDb : callbackUrlFromEvent;
                        return this.conversationDAO.findByConversationIdAndAccountId(convEvent.getId(), accountId).flatMap(existingConv -> {
                            log.info("CONVERSATION FOUND {}", existingConv);
                            return this.saveOrUpdate(this.buildTConversationObjectFromEvent(convEvent, existingConv, contactIdSaved, accountId, callbackUrl), labels);
                        }).switchIfEmpty(Mono.deferContextual(ctx -> {
                            log.info("CONVERSATION NOT FOUND, SAVING NEW CONVERSATION TO ACCOUNT: {}", accountId);
                            return this.saveOrUpdate(this.buildTConversationObjectFromEvent(convEvent, null, contactIdSaved, accountId, callbackUrl), labels);
                        }));
                    });
                });
            });
        });
    }

    public Mono<String> filterConversationsAndValidate(Long conversationId, String accountId, String newStatus) {
        return this.validateIfConversationIsVigent(conversationId, accountId).flatMap(validStateConversation -> {
            if (validStateConversation.equals(ConversationStateEnum.INVALID.getState())) {
                log.info("CONVERSATION IS RESOLVED");
                if (newStatus.equals(StatusUtil.ST_CONVERSATION_RESOLVED)) {
                    return this.conversationDAO.updateStatusByConversationIdAndAccountId(conversationId, StatusUtil.ST_CONVERSATION_RESOLVED, accountId).thenReturn(validStateConversation);
                }
                TextMessage textMessage = new TextMessage();
                textMessage.setContent(StatusUtil.MSG_CONVERSACION_CERRADA);
                textMessage.setPrivate(true);
                textMessage.setContentType("text");
                textMessage.setMessageType("outgoing");
                return this.tsaMessageService.sendMesssageToTSA(textMessage, String.valueOf(conversationId), accountId).then(this.tsaConversationApiService.toggleStatusConversation(conversationId, StatusUtil.ST_CONVERSATION_RESOLVED, accountId)).then(this.conversationDAO.updateStatusByConversationIdAndAccountId(conversationId, StatusUtil.ST_CONVERSATION_RESOLVED, accountId)).thenReturn(validStateConversation);
            }
            return Mono.just((Object)validStateConversation);
        });
    }

    public Mono<String> closeConversation(String identifier, String accountId) {
        log.info("CERRANDO CONVERSACION {} {}", (Object)identifier, (Object)accountId);
        return this.conversationDAO.findConversationByIdentifierAndStatusAndAccountId(identifier, StatusUtil.ST_CONVERSATION_RESOLVED, accountId).flatMap(conversation -> this.tsaConversationApiService.toggleStatusConversation(conversation.getConversationId(), StatusUtil.ST_CONVERSATION_RESOLVED, accountId).then(this.conversationDAO.updateStatusByConversationIdAndAccountId(conversation.getConversationId(), StatusUtil.ST_CONVERSATION_RESOLVED, accountId)).thenReturn((Object)"CONVERSATION CLOSED"));
    }

    private Mono<TConversation> validarConversacionCerradaGuardarEtiqueta(Long conversationId, Long teamId, List<String> labels) {
        return this.teamService.findAccountIdByTeamId(teamId).flatMap(accountId -> {
            String[] arrayLabels = labels.toArray(new String[0]);
            return this.conversationDAO.syncLabels(conversationId, accountId, arrayLabels).flatMap(responseDb -> {
                log.info("etiqueta de cierre de conversacion agregada {}, {}", (Object)conversationId, accountId);
                return Mono.empty();
            });
        });
    }

    public Mono<Void> openNewConversation(CreateConversationModel conversationModel, String accountId) {
        log.info("IS OPENING A NEW CONVERSATION");
        return this.tsaConversationApiService.createNewConversationTSA(conversationModel, accountId).flatMap(conversation -> {
            Team team;
            log.info("CONVERSATION CREATED {}", conversation);
            Meta meta = conversation.getMeta();
            Long contactidTsa = conversation.getMeta().getSender().getId();
            List labels = conversation.getLabels() != null ? conversation.getLabels() : List.of();
            TConversation tconversation = new TConversation();
            tconversation.setAgentId(this.getAgentId(meta));
            tconversation.setAccountId(accountId);
            tconversation.setConversationId(conversation.getId());
            tconversation.setCreatedAt(LocalDateTime.now());
            tconversation.setUpdatedAt(LocalDateTime.now());
            tconversation.setStatus(conversation.getStatus());
            tconversation.setInboxId(conversation.getInboxId());
            if (meta != null && (team = meta.getTeam()) != null) {
                tconversation.setTeamId(team.getId());
            }
            tconversation.setCallbackUrl(conversationModel.getAdditionalAttributes().getCallbackUrl());
            return this.contactService.findIdContactByIdTsa(contactidTsa, accountId).flatMap(contactId -> {
                tconversation.setContactId(contactId);
                return this.saveOrUpdate(tconversation, labels).then();
            }).then();
        });
    }

    public Mono<String> validateIfConversationIsVigent(Long conversationId, String accountId) {
        return this.conversationDAO.isValidConversationByConversationIdAndAccountId(conversationId, accountId).flatMap(isValid -> {
            log.info("IS VALID CONVERSATION {}", isValid);
            return Mono.just((Object)isValid);
        });
    }

    public Mono<TConversation> findConversationByIdentifier(String identifier, String accountId) {
        return this.conversationDAO.findConversationByIdentifierAndStatusAndAccountId(identifier, StatusUtil.ST_CONVERSATION_RESOLVED, accountId);
    }

    private Mono<Long> validateIfContactExists(Long idTsa, String accountId) {
        return this.contactService.findIdContactByIdTsa(idTsa, accountId).defaultIfEmpty((Object)0L).flatMap(contactId -> {
            log.info("contact allowed {}, find {}", contactId, (Object)idTsa);
            if (contactId != 0L) {
                return Mono.just((Object)contactId);
            }
            return this.tsaContactApiService.getContactById(idTsa, accountId).flatMap(payload -> {
                log.info("RESPONSE {}", payload);
                return this.contactService.saveOrUpdateContactFromApiConversation(payload, accountId).map(TContact::getId);
            });
        });
    }

    private TConversation buildTConversationObjectFromEvent(ConversationEvent evt, TConversation conv, Long contactId, String accountId, String callbackUrl) {
        Team team;
        TConversation conversation;
        log.warn("fecha de asignacion: {}", (Object)evt.getFirstReplyCreatedAt());
        if (conv != null) {
            conversation = conv;
            if (conversation.getCallbackUrl() == null) {
                conversation.setCallbackUrl(callbackUrl);
            }
        } else {
            conversation = new TConversation();
            conversation.setCallbackUrl(callbackUrl);
        }
        Meta meta = evt.getMeta();
        conversation.setAgentId(this.getAgentId(meta));
        conversation.setFirstReplyCreatedAt(FechaUtils.convertirALocalDateTimeEcuador((LocalDateTime)evt.getFirstReplyCreatedAt()));
        conversation.setAccountId(accountId);
        conversation.setContactId(contactId);
        conversation.setConversationId(evt.getId());
        if (conv == null) {
            conversation.setCreatedAt(LocalDateTime.now());
        }
        conversation.setUpdatedAt(LocalDateTime.now());
        conversation.setStatus(evt.getStatus());
        conversation.setInboxId(evt.getInboxId());
        if (evt.getMeta() != null && (team = evt.getMeta().getTeam()) != null) {
            conversation.setTeamId(team.getId());
        }
        return conversation;
    }

    private Long getAgentId(Meta metaConversation) {
        Sender assignee;
        if (metaConversation != null && (assignee = metaConversation.getAssignee()) != null) {
            return assignee.getId();
        }
        return null;
    }

    public Flux<TConversation> findAllConversationsToClose() {
        return this.conversationDAO.findAllConversationsToClose();
    }

    public Flux<TConversation> findAllConversationsNotClosedToSetTagsOnTsa() {
        return this.conversationDAO.findAllConversationsNotClosedToSetTagsOnTsa();
    }

    public Mono<Integer> updateConversationNotifiedTags(Long conversationTwsId) {
        return this.conversationDAO.updateActionsTsaTagsByConversationTwsId(conversationTwsId);
    }

    public Mono<Integer> updateConversationStatus(Long conversationId, String status, String accountId) {
        return this.conversationDAO.updateStatusByConversationIdAndAccountId(conversationId, status, accountId);
    }

    public Mono<String> findIdentifierByidConversationAndAccountId(Long idConversation, String accountId) {
        return this.conversationCacheService.getIdentifierByIdConversation(idConversation, accountId).switchIfEmpty(this.conversationDAO.findIdentifierByConversationIdAndAccountId(idConversation, accountId).flatMap(identifier -> this.conversationCacheService.setIdentifierByIdConversation(idConversation, accountId, identifier).thenReturn(identifier)));
    }

    public Mono<String> findCallbackUrlFromConversationIdAndAccountId(String conversationId, String accountId) {
        return this.conversationCacheService.getCallbackUrlByConversationId(conversationId, accountId).switchIfEmpty(this.conversationDAO.findCallbackUrlByConversationIdAndAccountId(Long.valueOf(Long.parseLong(conversationId)), accountId).flatMap(url -> this.conversationCacheService.setCallbackUrlByConversationId(conversationId, accountId, url).thenReturn(url)));
    }

    public Mono<List<ConversationPayload>> getConversationsNotAssigned(String accountId) {
        return this.tsaConversationApiService.getListConversationsNotAssigned(accountId).flatMap(conversationDataNotAssigned -> {
            if (conversationDataNotAssigned.getData() == null || conversationDataNotAssigned.getData().getMeta() == null) {
                log.info("No conversations to assign");
                return Mono.empty();
            }
            ConvMetaNotAssigned metaConversations = conversationDataNotAssigned.getData().getMeta();
            if (metaConversations.getUnassignedCount() == 0) {
                log.info("No conversations to assign");
                return Mono.empty();
            }
            return Mono.just((Object)conversationDataNotAssigned.getData().getPayload());
        });
    }

    public ConversationServiceImpl(ConversationCacheService conversationCacheService, TeamService teamService, ConversationDAO conversationDAO, TsaContactApiService tsaContactApiService, TsaConversationApiService tsaConversationApiService, ContactService contactService, TsaMessageService tsaMessageService, RedissonConversationLockService redissonConversationLockService, Environment env) {
        this.conversationCacheService = conversationCacheService;
        this.teamService = teamService;
        this.conversationDAO = conversationDAO;
        this.tsaContactApiService = tsaContactApiService;
        this.tsaConversationApiService = tsaConversationApiService;
        this.contactService = contactService;
        this.tsaMessageService = tsaMessageService;
        this.redissonConversationLockService = redissonConversationLockService;
        this.env = env;
    }
}

