/*
 * Decompiled with CFR 0.152.
 */
package com.agent.tsa.service.impl;

import com.agent.tsa.service.AudioConversionService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class AudioConversionServiceImpl
implements AudioConversionService {
    private static final Logger log = LoggerFactory.getLogger(AudioConversionServiceImpl.class);

    public Mono<File> convertOgaToMp3(String sourceFilePath, String fileId, String rutaTemporal) {
        log.info("Convirtiendo archivo OGA a MP3: {}", (Object)sourceFilePath);
        return Mono.fromCallable(() -> {
            File outputFile = new File(rutaTemporal, fileId.concat(".mp3"));
            String command = String.format("ffmpeg -i %s -acodec libmp3lame -q:a 2 %s", sourceFilePath, outputFile.getAbsolutePath());
            ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Error al convertir el archivo. C\u00f3digo de salida: " + exitCode);
            }
            System.out.println("Archivo convertido exitosamente: " + outputFile.getAbsolutePath());
            return outputFile;
        });
    }
}

