/*
 * Decompiled with CFR 0.152.
 */
package com.agent.interceptors;

import com.agent.exceptions.CustomException;
import com.agent.utils.ApiResponse;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={WebExchangeBindException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleValidationExceptions(WebExchangeBindException ex) {
        HashMap errors = new HashMap();
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        ApiResponse response = ApiResponse.error((int)HttpStatus.NOT_ACCEPTABLE.value(), errors);
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.NOT_ACCEPTABLE));
    }

    @ExceptionHandler(value={Exception.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGlobalException(Exception ex, ServerWebExchange exchange) {
        log.error("ERROR", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGlobalException(RuntimeException ex, ServerWebExchange exchange) {
        log.error("ERROR", (Throwable)ex);
        ApiResponse response = ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error, no se logr\u00f3 culminar el proceso.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={CustomException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleGlobalException(CustomException ex, ServerWebExchange exchange) {
        ApiResponse response = ApiResponse.error((int)ex.getHttpStatus().value(), (String)ex.getMessage());
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)ex.getHttpStatus()));
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    public Mono<ResponseEntity<ApiResponse<Object>>> handleAsyncRequestTimeoutException(ServerWebExchange exchange) {
        ApiResponse response = ApiResponse.error((int)HttpStatus.REQUEST_TIMEOUT.value(), (String)"La solicitud ha tardado demasiado tiempo en procesarse.");
        return Mono.just((Object)new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.REQUEST_TIMEOUT));
    }
}

