/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.data.RequestMessageModel;
import com.agent.tsa.events.MessageEvent;
import com.agent.tsa.events.ResponseMessageEvent;
import com.agent.tsa.service.MessageService;
import com.agent.tsa.service.ThinkAgentService;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/webhook/tsa"})
public class WebhookController {
    private static final Logger log = LoggerFactory.getLogger(WebhookController.class);
    private final ThinkAgentService thinkAgentService;
    private final MessageService messageService;

    @PostMapping(value={"/sendMessage/{callbackid}/source/{source}"})
    public Mono<ResponseEntity<ResponseMessageEvent>> callbackSendMessageTSA(@PathVariable String callbackid, @PathVariable String source, @RequestBody @Valid RequestMessageModel request) {
        log.info("WEBHOOK MESSAGES {} {}", (Object)callbackid, (Object)request);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "ok");
        return this.messageService.processRequestToSendMessage(request, callbackid, source).flatMap(responseMessageEvent -> {
            log.info("Response Message Event: {}", responseMessageEvent);
            return Mono.just((Object)ResponseEntity.ok((Object)responseMessageEvent));
        });
    }

    @PostMapping(value={"/sendMessage/{callbackid}"})
    public Mono<ResponseEntity<String>> callbackSendMessageTSAFromMotopower(@PathVariable String callbackid, @RequestBody @Valid RequestMessageModel request) {
        log.info("WEBHOOK MESSAGES {} {}", (Object)callbackid, (Object)request);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("status", "ok");
        return this.messageService.processRequestToSendMessage(request, callbackid, null).then(Mono.just((Object)ResponseEntity.ok((Object)((Object)response).toString())));
    }

    @PostMapping
    public Mono<ResponseEntity<String>> callbackTSA(@RequestBody Map<String, Object> body) {
        log.info("tsa webhook {}", body);
        return this.thinkAgentService.processWebhookFromTAS(body);
    }

    @PostMapping(value={"/conversationStatusChanged"})
    public Mono<Void> conversationStatusChangred(@RequestBody Object body) {
        log.info("Conversation status webhook {}", body);
        return Mono.empty();
    }

    @PostMapping(value={"/test"})
    public Mono<Void> callbackSendMessageTSATEST(@RequestBody Object body) {
        log.info("simulation of client recipt {} {}", body);
        return Mono.empty();
    }

    @PostMapping(value={"/test/messages"})
    public Mono<ResponseEntity<String>> callbackSendMessageTSAMessagesTEST(@RequestBody MessageEvent body) {
        log.info("message of client recipt {}", (Object)body.getInbox());
        return this.thinkAgentService.processMessageFromWebhook(body);
    }

    @PostMapping(value={"/test/messages/whatsapp"})
    public Mono<ResponseEntity<String>> callbackSendMessageWhatsapp(@RequestBody Object body) {
        log.info("message of whatsapp {}", body);
        return Mono.just((Object)ResponseEntity.ok().build());
    }

    @PostMapping(value={"/test/messages/messenger"})
    public Mono<ResponseEntity<String>> callbackSendMessageTSAMessageMessenger(@RequestBody Object body) {
        log.info("message of messenger {}", body);
        return Mono.just((Object)ResponseEntity.ok().build());
    }

    public WebhookController(ThinkAgentService thinkAgentService, MessageService messageService) {
        this.thinkAgentService = thinkAgentService;
        this.messageService = messageService;
    }
}

