/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.DTO.ConversationsCountDTO;
import com.agent.tsa.DTO.RequestReportCountConversationsDTO;
import com.agent.tsa.service.ReportService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"api/ms/reports"})
public class ReportsController {
    private static final Logger log = LoggerFactory.getLogger(ReportsController.class);
    private final ReportService reportService;

    @PostMapping(value={"/daily-conversations/{empresa}"})
    public Mono<List<ConversationsCountDTO>> getConversationsCount(@PathVariable String empresa, @RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.getConversationsCount(empresa, body.getInitDate(), body.getEndDate());
    }

    @PostMapping(value={"daily-conversations-labels/{empresa}"})
    public Flux<?> getConversationsLabelsReport(@PathVariable String empresa, @RequestBody RequestReportCountConversationsDTO body) {
        return this.reportService.getConversationLabelsCountByDateAndAccountId(empresa, body.getInitDate(), body.getEndDate());
    }

    public ReportsController(ReportService reportService) {
        this.reportService = reportService;
    }
}

