/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.tsa.entity.views.ViewInteractionsReport;
import com.agent.tsa.service.InteractionReportService;
import com.agent.tsa.utils.CsvUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"report-interactions"})
public class ReportInteractionsController {
    private static final Logger log = LoggerFactory.getLogger(ReportInteractionsController.class);
    private final InteractionReportService interactionReportService;

    @PostMapping(value={"mxtws2024/interactions"})
    public Mono<?> getInteractionsReport(@RequestBody Map body) {
        log.info("getInteractionsReport: {}", (Object)body);
        int page = (Integer)body.get("page");
        int size = (Integer)body.get("size");
        String initDate = (String)body.get("startDate");
        String endDate = (String)body.get("endDate");
        return this.interactionReportService.getInteractionsReport(page, size, initDate, endDate);
    }

    @GetMapping(value={"/mxtws2024/export-csv"})
    public Mono<Void> exportToCSV(@RequestParam String initDate, @RequestParam String endDate, ServerHttpResponse response) {
        log.info("exportToCSV: initDate={}, endDate={}", (Object)initDate, (Object)endDate);
        response.getHeaders().set("Content-Disposition", "attachment; filename=\"ReporteEstadisticas.csv\"");
        response.getHeaders().set("Content-Type", "application/octet-stream");
        Flux reports = this.interactionReportService.getInteractionsReport(initDate, endDate);
        byte[] bom = new byte[]{-17, -69, -65};
        DefaultDataBufferFactory bufferFactory = new DefaultDataBufferFactory();
        DefaultDataBuffer bomBuffer = bufferFactory.wrap(bom);
        DefaultDataBuffer header = bufferFactory.wrap("Sistema id,identificaci\u00f3n,conversaci\u00f3n id,fecha de creaci\u00f3n,hora de creaci\u00f3n,tel\u00e9fono,fecha de la primera asignaci\u00f3n,hora de la primera asignaci\u00f3n,fecha de la \u00faltima asignaci\u00f3n,hora de la \u00faltima asignaci\u00f3n,canal,sub canal, tipo sub canal,derivado asesor\n".getBytes(StandardCharsets.UTF_8));
        Flux dataBufferFlux = reports.map(report -> {
            log.info("Processing report: {}", report);
            String csvLine = CsvUtils.convertToCSV((ViewInteractionsReport)report);
            byte[] bytes = (csvLine + "\n").getBytes(StandardCharsets.UTF_8);
            return bufferFactory.wrap(bytes);
        });
        Flux result = Flux.concat((Publisher[])new Publisher[]{Mono.just((Object)bomBuffer), Mono.just((Object)header), dataBufferFlux});
        return response.writeWith((Publisher)result);
    }

    public ReportInteractionsController(InteractionReportService interactionReportService) {
        this.interactionReportService = interactionReportService;
    }
}

