/*
 * Decompiled with CFR 0.152.
 */
package com.agent.controller;

import com.agent.auto.ScheduleConfig;
import com.agent.tsa.service.RoundRobinAssignmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"assign"})
public class AutoAssignController {
    private static final Logger log = LoggerFactory.getLogger(AutoAssignController.class);
    private final RoundRobinAssignmentService assignmentService;
    private final ScheduleConfig config;

    @GetMapping(value={"/conversations"})
    public Mono<String> autoAssignConversations() {
        log.info("Asignacion desde el controlador");
        for (Long companyId : this.config.getCompanyIds()) {
            log.info("\u23f1 Ejecutando asignaci\u00f3n para empresa ID: {}", (Object)companyId);
            this.assignmentService.assignConversations(companyId.toString()).subscribe();
        }
        return Mono.just((Object)"Asignacion Completada");
    }

    public AutoAssignController(RoundRobinAssignmentService assignmentService, ScheduleConfig config) {
        this.assignmentService = assignmentService;
        this.config = config;
    }
}

