/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.tsa.message;

import com.agent.client.tsa.message.service.TsaMessageService;
import com.agent.tsa.data.FileDownloadMeta;
import com.agent.tsa.data.conversation.messages.CallbackTsaMessage;
import com.agent.tsa.models.conversation.TextMessage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaMessageApiServiceImpl
implements TsaMessageService {
    private static final Logger log = LoggerFactory.getLogger(TsaMessageApiServiceImpl.class);
    private final WebClient.Builder webClient;
    private final ObjectMapper objectMapper;
    private final Environment env;

    public Mono<CallbackTsaMessage> sendMesssageToTSA(TextMessage data, String conversationId, String acountId) {
        String API_URL = this.env.getProperty("tsa.api.message.template").replace("{account_id}", acountId).replace("{conversation_id}", conversationId);
        String token = this.env.getProperty("tsa.api.token");
        log.info(API_URL);
        log.info("REQUEST TO TSA {}", (Object)data);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("api_access_token", token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)data).retrieve().bodyToMono(CallbackTsaMessage.class).flatMap(response -> {
            log.info("response tsa {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<CallbackTsaMessage> sendMultipartMessageToTSA(FileDownloadMeta fileDownloadMeta, String conversationId, String caption, String acountId) {
        log.info("sending files to TSA");
        String API_URL = this.env.getProperty("tsa.api.message.template").replace("{account_id}", acountId).replace("{conversation_id}", conversationId);
        log.info("Sending to {}", (Object)API_URL);
        String token = this.env.getProperty("tsa.api.token");
        String directorio = this.validarDirectorio();
        String fileDir = directorio.concat(fileDownloadMeta.getName());
        System.out.println("name: " + fileDownloadMeta.getName());
        Path path = Paths.get(fileDir, new String[0]);
        try {
            Files.write(path, fileDownloadMeta.getData(), new OpenOption[0]);
            HttpHeaders headers = new HttpHeaders();
            File file = new File(fileDir);
            FileSystemResource fileResource = new FileSystemResource(file);
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            headers.set("api_access_token", token);
            LinkedMultiValueMap multipartData = new LinkedMultiValueMap();
            multipartData.add((Object)"attachments[]", (Object)fileResource);
            multipartData.add((Object)"message_type", (Object)"incoming");
            if (caption != null) {
                multipartData.add((Object)"content", (Object)caption);
            }
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)multipartData)).retrieve().bodyToMono(CallbackTsaMessage.class).flatMap(ignore -> {
                file.delete();
                return Mono.just((Object)ignore);
            });
        }
        catch (Exception e) {
            log.error("ERROR AL ENVIAR EL ARCHIVO AL API DE TSA", (Throwable)e);
            return Mono.empty();
        }
    }

    private String validarDirectorio() {
        String tempPath = this.env.getProperty("tsa.files.temp");
        File directory = new File(tempPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return tempPath;
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsaMessageApiServiceImpl)) {
            return false;
        }
        TsaMessageApiServiceImpl other = (TsaMessageApiServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsaMessageApiServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "TsaMessageApiServiceImpl(webClient=" + String.valueOf(this.getWebClient()) + ", objectMapper=" + String.valueOf(this.getObjectMapper()) + ", env=" + String.valueOf(this.getEnv()) + ")";
    }

    public TsaMessageApiServiceImpl(WebClient.Builder webClient, ObjectMapper objectMapper, Environment env) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
        this.env = env;
    }
}

