/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.tsa.files;

import com.agent.client.tsa.files.TsaFileServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaFileServerImpl
implements TsaFileServer {
    private static final Logger log = LoggerFactory.getLogger(TsaFileServerImpl.class);
    private final WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();

    public Mono<byte[]> getFileBytesWithRedirectHandling(String fileUrl) {
        return this.webClient.get().uri(fileUrl, new Object[0]).exchangeToMono(clientResponse -> {
            if (clientResponse.statusCode().is3xxRedirection()) {
                String location = (String)clientResponse.headers().header("Location").get(0);
                log.info("Redirigiendo a nueva URL: {}", (Object)location);
                return this.getFileBytesWithRedirectHandling(location);
            }
            if (clientResponse.statusCode().is2xxSuccessful()) {
                log.info("Descargando archivo desde URL: {}", (Object)fileUrl);
                return clientResponse.bodyToMono(byte[].class);
            }
            return clientResponse.bodyToMono(String.class).flatMap(body -> Mono.error((Throwable)new RuntimeException("Error en la solicitud HTTP. Estado: " + String.valueOf(clientResponse.statusCode()) + ", Respuesta: " + body)));
        }).doOnNext(fileBytes -> {
            if (fileBytes == null || ((byte[])fileBytes).length == 0) {
                throw new RuntimeException("El archivo descargado est\u00e1 vac\u00edo.");
            }
            log.info("Archivo descargado correctamente. Tama\u00f1o: {} bytes", (Object)((byte[])fileBytes).length);
        }).doOnError(error -> log.error("Error al realizar la solicitud HTTP: {}", (Object)error.getMessage(), error));
    }
}

