/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.tsa.contact;

import com.agent.client.tsa.contact.models.CreateContactModel;
import com.agent.client.tsa.contact.models.CreateContactResponse;
import com.agent.client.tsa.contact.models.PayloadContactTsa;
import com.agent.client.tsa.contact.models.PayloadFindContact;
import com.agent.client.tsa.contact.models.PayloadFindContactById;
import com.agent.client.tsa.contact.service.TsaContactApiService;
import com.agent.exceptions.CustomException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaContactApiServiceImpl
implements TsaContactApiService {
    private static final Logger log = LoggerFactory.getLogger(TsaContactApiServiceImpl.class);
    private final Environment env;
    private final WebClient.Builder webClient;

    public Mono<PayloadFindContactById> getContactById(Long contactId, String accountId) {
        log.info("MAKING CALL TO FIND CONTACT BY TSA ID");
        String urlTemplateFindById = this.env.getProperty("tsa.url.contacts.find").replace("{account_id}", accountId).replace("{contact_id}", String.valueOf(contactId));
        return this.webClient.build().get().uri(urlTemplateFindById, new Object[0]).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")}).retrieve().bodyToMono(PayloadFindContactById.class).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.empty();
        }).doOnError(error -> log.error("Error making API call", error));
    }

    public Mono<PayloadContactTsa> getContactByParam(String param, String accountId) {
        log.info("MAKING CALL TO GET CONTACT BY PARAM {}", (Object)param);
        String urlTemplateFindById = this.env.getProperty("tsa.url.contacts.find.query").replace("{account_id}", accountId).replace("{param}", String.valueOf(param));
        return this.webClient.build().get().uri(urlTemplateFindById, new Object[0]).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")}).retrieve().bodyToMono(PayloadFindContact.class).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.empty();
        }).flatMap(response -> {
            if (response.getPayload().isEmpty()) {
                return Mono.empty();
            }
            List payload = response.getPayload();
            for (PayloadContactTsa value : payload) {
                if (!value.getIdentifier().equals(param)) continue;
                return Mono.just((Object)value);
            }
            return Mono.empty();
        }).doOnError(error -> log.error("Error making API call", error));
    }

    public Mono<CreateContactResponse> createNewContact(CreateContactModel contact, String accountId) {
        log.info("MAKING CALL TO CREATE A NEW CONTACT BY IDENTIFIER {}", (Object)contact);
        String urlCreate = this.env.getProperty("tsa.url.contact").replace("{account_id}", accountId);
        log.info("URL: {}", (Object)urlCreate);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(urlCreate, new Object[0])).header("api_access_token", new String[]{this.env.getProperty("tsa.api.token")})).bodyValue((Object)contact).retrieve().bodyToMono(CreateContactResponse.class).doOnSuccess(response -> log.info("CONTACT CREATED SUCCESSFUL: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.error((Throwable)new CustomException("Error al crear el contacto", HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    public Environment getEnv() {
        return this.env;
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsaContactApiServiceImpl)) {
            return false;
        }
        TsaContactApiServiceImpl other = (TsaContactApiServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        return !(this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsaContactApiServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        return result;
    }

    public String toString() {
        return "TsaContactApiServiceImpl(env=" + String.valueOf(this.getEnv()) + ", webClient=" + String.valueOf(this.getWebClient()) + ")";
    }

    public TsaContactApiServiceImpl(Environment env, WebClient.Builder webClient) {
        this.env = env;
        this.webClient = webClient;
    }
}

