/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.external;

import com.agent.client.external.service.SendMessagesToApiService;
import com.agent.tsa.data.RequestMessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class SendMessageToAPIServiceImpl
implements SendMessagesToApiService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageToAPIServiceImpl.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<ResponseEntity<String>> sendMessageToWebhook(RequestMessageModel conversationModel, String API_URL) {
        log.info(API_URL);
        log.info("REQUEST TO TSA {}", (Object)conversationModel);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)conversationModel).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response tsa {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
        }).onErrorResume(e -> {
            log.error("Error sending message to TSA: ", e);
            return Mono.just((Object)ResponseEntity.badRequest().body((Object)"Failed to send message"));
        });
    }

    public Mono<ResponseEntity<String>> closeConversation(String identifier, String accountId) {
        log.info("CLOSING CONVERSATION {}", (Object)identifier);
        String API_URL = this.env.getProperty("client.close.conversation.whatsapp.".concat(accountId)).concat("?conversationId=").concat(identifier);
        log.info("API_URL: {}", (Object)API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("Response from TSA: {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
        }).onErrorResume(e -> {
            log.error("Error sending message to TSA: ", e);
            return Mono.just((Object)ResponseEntity.badRequest().body((Object)"Failed to send message"));
        });
    }

    public SendMessageToAPIServiceImpl(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

