/*
 * Decompiled with CFR 0.152.
 */
package com.agent.client.campana;

import com.agent.client.campana.CampanaRestClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class CampanaRestClientServiceImpl
implements CampanaRestClientService {
    private static final Logger log = LoggerFactory.getLogger(CampanaRestClientServiceImpl.class);
    private final Environment env;
    private final WebClient.Builder webClient;

    public Mono<String> getUserNameByConversationIdAndCanal(String identifier, String canal) {
        String url = this.env.getProperty("campana.api.url") + "/username?conversationId=" + identifier + "&canal=" + canal;
        log.info("Realizando petici\u00f3n a Campa\u00f1a: GET {}", (Object)url);
        return this.webClient.build().get().uri(url, new Object[0]).retrieve().bodyToMono(String.class).doOnNext(userName -> log.info("USERNAME obtenido desde campa\u00f1a: {}", userName)).onErrorResume(error -> {
            log.error("Error al obtener username desde campa\u00f1a", error);
            return Mono.empty();
        });
    }

    public CampanaRestClientServiceImpl(Environment env, WebClient.Builder webClient) {
        this.env = env;
        this.webClient = webClient;
    }
}

