/*
 * Decompiled with CFR 0.152.
 */
package com.agent.cache;

import com.agent.utils.RedisUtils;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class TeamCacheService {
    private static final Logger log = LoggerFactory.getLogger(TeamCacheService.class);
    private final ReactiveRedisTemplate<String, String> redisTemplate;
    private static final String REDIS_KEY_CALLBACK = "callbackUrlByTeamIdAndAccountId:ids";
    private static final String REDIS_KEY_TEAM = "teamIdByCallbackId:ids";
    private static final String REDIS_KEY_INBOX = "inboxIdByCallbackId:ids";
    private static final String REDIS_KEY_ACCOUNT_BY_CALLBACK = "accountIdByCallbackId:ids";
    private static final String REDIS_KEY_ACCOUNT_BY_INBOX = "accountIdByInboxId:ids";
    private static final String REDIS_KEY_ACCOUNT_BY_TEAM = "accountIdByTeamId:ids";

    public Mono<String> getCallbackUrlByTeamIdAndAccountId(String teamId, String accountId) {
        String redisKey = teamId + ":" + accountId;
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_CALLBACK, (Object)redisKey).map(Object::toString);
    }

    public Mono<String> getAccountIdByCallbackId(String callbackId) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_ACCOUNT_BY_CALLBACK, (Object)callbackId).map(Object::toString);
    }

    public Mono<String> getTeamIdByCallbackId(String callbackId) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_TEAM, (Object)callbackId).map(Object::toString);
    }

    public Mono<String> getInboxIdByCallbackId(String callbackId) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_INBOX, (Object)callbackId).map(Object::toString);
    }

    public Mono<String> getAccountIdByInboxId(String inboxId) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_ACCOUNT_BY_INBOX, (Object)inboxId).map(Object::toString);
    }

    public Mono<String> getAccountIdByTeamId(String teamId) {
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_ACCOUNT_BY_TEAM, (Object)teamId).map(Object::toString);
    }

    public Mono<Boolean> setCallbackUrlByTeamIdAndAccountId(String teamId, String accountId, String url) {
        String redisKey = teamId + ":" + accountId;
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_CALLBACK, (Object)redisKey, (Object)url).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_CALLBACK, (Duration)Duration.ofHours(24L)));
    }

    public Mono<Boolean> setAccountIdByCallbackId(String callbackId, String accountId) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_ACCOUNT_BY_CALLBACK, (Object)callbackId, (Object)accountId).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_ACCOUNT_BY_CALLBACK, (Duration)Duration.ofHours(24L)));
    }

    public Mono<Boolean> setTeamIdByCallbackId(String callbackId, String teamId) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_TEAM, (Object)callbackId, (Object)teamId).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_TEAM, (Duration)Duration.ofHours(24L)));
    }

    public Mono<Boolean> setInboxIdByCallbackId(String callbackId, String inboxId) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_INBOX, (Object)callbackId, (Object)inboxId).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_INBOX, (Duration)Duration.ofHours(24L)));
    }

    public Mono<Boolean> setAccountIdByInboxId(String inboxId, String accountId) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_ACCOUNT_BY_INBOX, (Object)inboxId, (Object)accountId).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_ACCOUNT_BY_INBOX, (Duration)Duration.ofHours(24L)));
    }

    public Mono<Boolean> setAccountIdByTeamId(String teamId, String accountId) {
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_ACCOUNT_BY_TEAM, (Object)teamId, (Object)accountId).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_ACCOUNT_BY_TEAM, (Duration)Duration.ofHours(24L)));
    }

    public TeamCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

