/*
 * Decompiled with CFR 0.152.
 */
package com.agent.cache;

import com.agent.utils.RedisUtils;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ConversationCacheService {
    private static final Logger log = LoggerFactory.getLogger(ConversationCacheService.class);
    private final ReactiveRedisTemplate<String, String> redisTemplate;
    private static final String REDIS_KEY_IDENTIFIER = "identifierByIdConversation:ids";
    private static final String REDIS_KEY_CALLBACK = "callbackUrlByConversationId:ids";

    public Mono<String> getIdentifierByIdConversation(Long idConversation, String accountId) {
        String redisKey = accountId + ":" + idConversation;
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_IDENTIFIER, (Object)redisKey).map(Object::toString);
    }

    public Mono<Boolean> setIdentifierByIdConversation(Long idConversation, String accountId, String identifier) {
        String redisKey = accountId + ":" + idConversation;
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_IDENTIFIER, (Object)redisKey, (Object)identifier).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_IDENTIFIER, (Duration)Duration.ofHours(24L)));
    }

    public Mono<String> getCallbackUrlByConversationId(String conversationId, String accountId) {
        String redisKey = accountId + ":" + conversationId;
        return this.redisTemplate.opsForHash().get((Object)REDIS_KEY_CALLBACK, (Object)redisKey).map(Object::toString);
    }

    public Mono<Boolean> setCallbackUrlByConversationId(String conversationId, String accountId, String callbackUrl) {
        String redisKey = accountId + ":" + conversationId;
        return this.redisTemplate.opsForHash().put((Object)REDIS_KEY_CALLBACK, (Object)redisKey, (Object)callbackUrl).then(RedisUtils.ApplyTTLifmissing((ReactiveRedisTemplate)this.redisTemplate, (String)REDIS_KEY_CALLBACK, (Duration)Duration.ofHours(24L)));
    }

    public ConversationCacheService(ReactiveRedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

